/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.BufferedReader;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.TexturePack2;

public class TexturePackCustom
extends TexturePack2 {
    private boolean isThereAnyError;
    private String errorMessage;

    public TexturePackCustom(Comcraft cc, String path) {
        super(cc, path);
    }

    public InputStream getResourceAsStream(String path) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)(String.valueOf(this.path) + path), (int)1);
            if (!fileConnection.exists()) {
                return super.getResourceAsStream(path);
            }
            InputStream inputStream = fileConnection.openInputStream();
            fileConnection.close();
            return inputStream;
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    protected void initTexturePack() {
        try {
            this.setTexturePackName(FileSystemHelper.getLastPathName(this.path));
            if (this.path.endsWith(".zip") || this.path.endsWith(".rar")) {
                this.isThereAnyError = true;
                this.errorMessage = this.cc.langBundle.getText("GuiSlotSelectTexturepack.unpackTexturepack");
                return;
            }
            FileConnection fileConnection = (FileConnection)Connector.open((String)(String.valueOf(this.path) + "info.txt"), (int)1);
            if (!fileConnection.exists()) {
                this.isThereAnyError = true;
                this.errorMessage = this.cc.langBundle.getText("GuiSlotSelectTexturepack.infoNotFound");
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileConnection.openInputStream()));
            this.setTexturePackDescription(bufferedReader.readLine());
            String widthLine = bufferedReader.readLine();
            String heightLine = bufferedReader.readLine();
            bufferedReader.close();
            if (widthLine == null || heightLine == null) {
                return;
            }
            int width = 0;
            int height = 0;
            try {
                width = Integer.parseInt(widthLine.trim());
                height = Integer.parseInt(heightLine.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setResolution(width, height);
            fileConnection.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public boolean isThereAnyError() {
        return this.isThereAnyError;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

