/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.simon816.minijoe.nativetypes.Background;
import java.util.Calendar;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Block;
import net.comcraft.src.Chunk;
import net.comcraft.src.ChunkPiece;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.Frustum;
import net.comcraft.src.Keyboard;
import net.comcraft.src.ModAPI;
import net.comcraft.src.RenderBlockPreview;
import net.comcraft.src.RenderBlocks;
import net.comcraft.src.RenderChunkPieces;
import net.comcraft.src.RenderEffects;
import net.comcraft.src.Touch;
import net.comcraft.src.Vec3D;

public final class Render {
    private final Comcraft cc;
    private Background background;
    private Camera camera;
    public Graphics3D g3D;
    public RenderBlocks renderBlock;
    public RenderBlockPreview renderBlockPreview;
    private Vector currentChunksList;
    private Frustum frustum;
    private static final Vec3D upVec = new Vec3D(0.0f, 1.0f, 0.0f);
    public long currentTick;
    public RenderEffects renderEffects;
    private Image targetGraphicsImage;

    public Render(Comcraft cc) {
        this.cc = cc;
        this.g3D = Graphics3D.getInstance();
        this.currentTick = 1L;
        this.renderEffects = new RenderEffects(cc);
        Calendar.getInstance().get(11);
    }

    public void initRender() {
        this.renderBlock = new RenderBlocks(this.cc);
        this.renderBlockPreview = new RenderBlockPreview(this.renderBlock);
        this.background = new Background();
        this.background.setColor(11591910);
        ModAPI.event.runEvent("Render.Init", new Object[]{this.background});
        this.camera = new Camera();
        this.reloadCamera();
        this.currentChunksList = new Vector(1024);
        this.frustum = new Frustum();
        this.reloadFrustum();
        this.reloadTargetGraphics();
    }

    public void reloadTargetGraphics() {
        if (this.cc.settings.resolutionScale != 1) {
            this.targetGraphicsImage = Image.createImage((int)(Comcraft.getScreenWidth() / this.cc.settings.resolutionScale), (int)(Comcraft.getScreenHeight() / this.cc.settings.resolutionScale));
            this.targetGraphicsImage.getGraphics();
        }
    }

    public Image getScreenshot() {
        Image image = Image.createImage((int)(Comcraft.getScreenWidth() * this.cc.settings.screenshotResolution / 2), (int)(Comcraft.getScreenHeight() * this.cc.settings.screenshotResolution / 2));
        Graphics g2 = image.getGraphics();
        Graphics g = this.cc.g;
        this.cc.g = g2;
        this.renderGame();
        this.cc.g = g;
        if (Touch.isTouchSupported()) {
            return Image.createImage((Image)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), (int)6);
        }
        return image;
    }

    public void reloadFrustum() {
        this.frustum.setCamInternals(this.cc.settings.fov + 3.0f + (float)this.cc.settings.renderDistance * 6.0f, (float)Comcraft.screenWidth / (float)Comcraft.screenHeight, 1.0f, 800.0f);
    }

    public void reloadCamera() {
        this.camera.setPerspective(this.cc.settings.fov, (float)Comcraft.screenWidth / (float)Comcraft.screenHeight, 1.0f, 800.0f);
    }

    public void releaseRender() {
        this.renderBlock.releaseRenderBlock();
        this.renderBlockPreview.releaseRenderBlockPreview();
    }

    public void reloadRender() {
        this.renderBlock.reloadRenderBlock();
        this.renderBlockPreview.reloadRenderBlockPreview();
    }

    public void renderAll() {
        this.clearScreen();
        if (!this.cc.isGamePaused) {
            if (this.cc.currentScreen == null || !this.cc.currentScreen.getSkipRender()) {
                this.renderGame();
            }
            if (this.cc.settings.renderGui) {
                this.cc.guiIngame.drawIngameGui();
            }
        }
        if (this.cc.currentScreen != null) {
            this.cc.currentScreen.drawScreen();
        }
        if (this.cc.settings.showFps) {
            this.drawFPS();
        }
        if (this.cc.settings.debugInfo) {
            this.drawDebugInfo();
        }
        this.cc.flushGraphics();
    }

    private void drawDebugInfo() {
        if (this.cc.world == null) {
            return;
        }
        int startX = Comcraft.screenWidth / 4;
        this.cc.g.setColor(0, 0, 0);
        this.cc.g.drawString("x: " + this.cc.player.xPos, startX, 3, 20);
        this.cc.g.drawString("y: " + this.cc.player.yPos, startX, 3 + (this.cc.g.getFont().getHeight() + 3), 20);
        this.cc.g.drawString("z: " + this.cc.player.zPos, startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 2, 20);
        this.cc.g.drawString("rotation yaw: " + this.cc.player.rotationYaw, startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 3, 20);
        this.cc.g.drawString("rotation pitch: " + this.cc.player.rotationPitch, startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 4, 20);
        this.cc.g.drawString("key: " + Keyboard.getCurrentKey(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 10, 20);
        this.cc.g.drawString("last key: " + Keyboard.getLastKey(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 11, 20);
        this.cc.g.drawString("loaded chunks: " + this.cc.world.chunkProvider.getLoadedChunksNum(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 5, 20);
        this.cc.g.drawString("chunks queue: " + this.cc.world.chunkProvider.getChunksQueueNum(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 6, 20);
        this.cc.g.drawString("free RAM: " + (float)Runtime.getRuntime().freeMemory() / 1048576.0f + " MB", startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 7, 20);
        this.cc.g.drawString("used RAM: " + (float)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0f + " MB", startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 8, 20);
        this.cc.g.drawString("total RAM: " + (float)Runtime.getRuntime().totalMemory() / 1048576.0f + " MB", startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 9, 20);
        this.cc.g.drawString("touch x: " + Touch.getX(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 12, 20);
        this.cc.g.drawString("touch y: " + Touch.getY(), startX, 3 + (this.cc.g.getFont().getHeight() + 3) * 13, 20);
    }

    private void renderGame() {
        if (this.cc.settings.fog) {
            this.renderBlock.setFogDistance(this.cc.settings.renderDistance * 40);
        }
        this.updateFrustum();
        this.g3D.bindTarget((Object)this.cc.g, true, this.cc.settings.antialiasing ? 2 : 0);
        this.g3D.clear(this.background._getBackground());
        this.g3D.setCamera(this.camera, this.cc.player.getPlayerTransform());
        try {
            try {
                this.renderWorld();
                this.renderEffects.renderEffects();
            }
            catch (OutOfMemoryError error) {
                if (!this.cc.settings.ignoreOutOfMemory) {
                    throw error;
                }
                this.g3D.releaseTarget();
            }
        }
        finally {
            this.g3D.releaseTarget();
        }
    }

    private void updateFrustum() {
        Vec3D posVec = this.cc.player.getPosition();
        Vec3D lookTemp = this.cc.player.getLook();
        Vec3D lookVec = new Vec3D(posVec.x - lookTemp.x, posVec.y + lookTemp.y, posVec.z - lookTemp.z);
        this.frustum.setCamDef(posVec, lookVec, upVec);
    }

    private void renderWorld() {
        this.cc.world.updateCurrentChunksList(this.currentChunksList);
        int i = 0;
        while (i < this.currentChunksList.size()) {
            this.renderChunkA((Chunk)this.currentChunksList.elementAt(i), true);
            ++i;
        }
        i = 0;
        while (i < this.currentChunksList.size()) {
            this.renderChunkA((Chunk)this.currentChunksList.elementAt(i), false);
            ++i;
        }
        ++this.currentTick;
    }

    private void renderChunkA(Chunk chunk, boolean renderOpaque) {
        if (chunk == null || chunk.isEmptyChunk()) {
            return;
        }
        RenderChunkPieces renderChunk = chunk.getRenderChunk();
        if (renderChunk == null) {
            return;
        }
        int xChunkCenter = (chunk.xPos << 2) + 2;
        int zChunkCenter = (chunk.zPos << 2) + 2;
        int i = 0;
        while (i < 8) {
            ChunkStorage blockStorage = chunk.getBlockStorageArray()[i];
            int yChunkCenter = (i << 2) + 2;
            if (blockStorage != null && blockStorage.containsBlocks && (renderOpaque || blockStorage.containsNonOpaqueBlocks) && this.frustum.sphereInFrustum(new Vec3D(xChunkCenter, yChunkCenter, zChunkCenter), 3.5f) != 0) {
                int z = 0;
                while (z < 4) {
                    int y = 0;
                    while (y < 4) {
                        int x = 0;
                        while (x < 4) {
                            ChunkPiece chunkPiece;
                            Block block = Block.blocksList[blockStorage.getBlockID(x, y, z)];
                            if (block != null && block.isNormal() == renderOpaque && (chunkPiece = renderChunk.chunkPieces[x][(i << 2) + y][z]) != null) {
                                this.renderBlock.renderBlockByRenderType(block, (chunk.xPos << 2) + x, (i << 2) + y, (chunk.zPos << 2) + z, chunkPiece.getTransform(), this.cc.player, chunkPiece);
                            }
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
            }
            ++i;
        }
    }

    private void clearScreen() {
        this.cc.g.setColor(this.background.getColor());
        this.cc.g.fillRect(0, 0, Comcraft.screenWidth, Comcraft.screenHeight);
    }

    private void drawFPS() {
        this.cc.g.setColor(0, 0, 0);
        this.cc.g.drawString("" + (int)(1.0f / this.cc.dt), 3, 3, 20);
    }
}

