/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.Packet;
import net.comcraft.src.ServerGame;
import net.comcraft.src.Vec3D;

public class PacketPlayerData
extends Packet {
    private static final int ACTION_JOIN = 1;
    private static final int ACTION_QUIT = 2;
    private static final int ACTION_MOVE = 3;
    private static final int ACTION_INVENTORY = 4;
    private EntityPlayer player = null;
    private int action;
    private int pId;
    private Object data = null;
    private int itmIndex;

    public PacketPlayerData() {
    }

    public PacketPlayerData(EntityPlayer player) {
        this.player = player;
    }

    public PacketPlayerData(int id, Vec3D position) {
        this.data = position;
        this.pId = id;
    }

    public PacketPlayerData(int index, InvItemStack itemstack) {
        this.data = itemstack;
        this.itmIndex = index;
    }

    public void writeData(DataOutputStream dos) throws IOException {
        if (this.player != null) {
            dos.write(1);
            this.player.writeToDataOutputStream(dos);
        } else if (this.data instanceof Vec3D) {
            dos.write(3);
            dos.writeInt(this.pId);
            dos.writeFloat(((Vec3D)this.data).x);
            dos.writeFloat(((Vec3D)this.data).y);
            dos.writeFloat(((Vec3D)this.data).z);
        } else if (this.data instanceof InvItemStack) {
            dos.write(4);
            dos.write(this.itmIndex);
            dos.writeShort(((InvItemStack)this.data).itemID);
            dos.write(((InvItemStack)this.data).stackSize);
        }
    }

    public void readData(DataInputStream dis) throws IOException {
        this.action = dis.read() & 0xFF;
        this.pId = dis.readInt();
        switch (this.action) {
            case 1: 
            case 3: {
                this.data = new Vec3D(dis.readFloat(), dis.readFloat(), dis.readFloat());
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                this.itmIndex = dis.read();
                this.data = new InvItemStack(dis.readShort(), dis.read());
                break;
            }
        }
    }

    public void process(ServerGame handler) {
        if (this.action == 3) {
            handler.handlePlayerMove(this.pId, (Vec3D)this.data);
        } else if (this.action == 1) {
            handler.handleNewPlayer(this.pId, (Vec3D)this.data);
        } else if (this.action == 2) {
            handler.handlePlayerQuit(this.pId);
        } else if (this.action == 4) {
            handler.handleInventoryChange(this.itmIndex, (InvItemStack)this.data);
        }
    }
}

