/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;
import net.comcraft.src.ZLIB;

public class PNGEncoder {
    static int[] crcTable = null;

    public static byte[] imageToPNG(Image image) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] alpha = new byte[width * height];
        byte[] red = new byte[width * height];
        byte[] green = new byte[width * height];
        byte[] blue = new byte[width * height];
        int[] data = new int[width];
        int y = 0;
        while (y < height) {
            image.getRGB(data, 0, width, 0, y, width, 1);
            int x = 0;
            while (x < width) {
                byte a;
                int c = data[x];
                byte b = (byte)(c & 0xFF);
                byte g = (byte)(c >> 8 & 0xFF);
                byte r = (byte)(c >> 16 & 0xFF);
                alpha[y * width + x] = a = (byte)(c >> 24 & 0xFF);
                red[y * width + x] = r;
                green[y * width + x] = g;
                blue[y * width + x] = b;
                ++x;
            }
            ++y;
        }
        image = null;
        data = null;
        System.gc();
        return PNGEncoder.toPNG(width, height, alpha, red, green, blue);
    }

    public static Image toImage(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) {
        try {
            byte[] png = PNGEncoder.toPNG(width, height, alpha, red, green, blue);
            return Image.createImage((byte[])png, (int)0, (int)png.length);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] toPNG(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] header = PNGEncoder.createHeaderChunk(width, height);
        byte[] data = PNGEncoder.createDataChunk(width, height, alpha, red, green, blue);
        byte[] trailer = PNGEncoder.createTrailerChunk();
        ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
        png.write(signature);
        png.write(header);
        png.write(data);
        png.write(trailer);
        return png.toByteArray();
    }

    public static byte[] createHeaderChunk(int width, int height) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(width);
        chunk.writeInt(height);
        chunk.writeByte(8);
        chunk.writeByte(6);
        chunk.writeByte(0);
        chunk.writeByte(0);
        chunk.writeByte(0);
        return PNGEncoder.toChunk("IHDR", baos.toByteArray());
    }

    public static byte[] createDataChunk(int width, int height, byte[] alpha, byte[] red, byte[] green, byte[] blue) throws IOException {
        int source = 0;
        int dest = 0;
        byte[] raw = new byte[4 * (width * height) + height];
        int y = 0;
        while (y < height) {
            raw[dest++] = 0;
            int x = 0;
            while (x < width) {
                raw[dest++] = red[source];
                raw[dest++] = green[source];
                raw[dest++] = blue[source];
                raw[dest++] = alpha[source++];
                ++x;
            }
            ++y;
        }
        return PNGEncoder.toChunk("IDAT", PNGEncoder.toZLIB(raw));
    }

    public static byte[] createTrailerChunk() throws IOException {
        return PNGEncoder.toChunk("IEND", new byte[0]);
    }

    public static byte[] toChunk(String id, byte[] raw) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
        DataOutputStream chunk = new DataOutputStream(baos);
        chunk.writeInt(raw.length);
        byte[] bid = new byte[4];
        int i = 0;
        while (i < 4) {
            bid[i] = (byte)id.charAt(i);
            ++i;
        }
        ((OutputStream)chunk).write(bid);
        ((OutputStream)chunk).write(raw);
        int crc = -1;
        crc = PNGEncoder.updateCRC(crc, bid);
        crc = PNGEncoder.updateCRC(crc, raw);
        chunk.writeInt(~crc);
        return baos.toByteArray();
    }

    public static void createCRCTable() {
        crcTable = new int[256];
        int i = 0;
        while (i < 256) {
            int c = i;
            int k = 0;
            while (k < 8) {
                c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
                ++k;
            }
            PNGEncoder.crcTable[i] = c;
            ++i;
        }
    }

    public static int updateCRC(int crc, byte[] raw) {
        if (crcTable == null) {
            PNGEncoder.createCRCTable();
        }
        int i = 0;
        while (i < raw.length) {
            crc = crcTable[(crc ^ raw[i]) & 0xFF] ^ crc >>> 8;
            ++i;
        }
        return crc;
    }

    public static byte[] toZLIB(byte[] raw) throws IOException {
        return ZLIB.toZLIB(raw);
    }
}

