/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsObject;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ServerGame;

public class InventoryPlayer
extends JsObject {
    private int selectedElement = 0;
    private InvItemStack[] elementsList = new InvItemStack[3];
    private ServerGame server;
    private static final int ID_GET_SELECTED_ELEMENT_NUM = 100;
    private static final int ID_GET_SELECTED_ITEM_STACK = 101;
    private static final int ID_SET_SELECTED_ELEMENT = 102;
    private static final int ID_GET_ITEM_STACK_AT = 103;
    private static final int ID_SET_ITEM_STACK_AT = 104;
    private static final int ID_GET_FAST_SLOT_SIZE = 105;

    public InventoryPlayer() {
        super(JsObject.OBJECT_PROTOTYPE);
        this.elementsList[0] = new InvItemStack(1, 1);
        this.elementsList[1] = new InvItemStack(2, 1);
        this.elementsList[2] = new InvItemStack(3, 1);
        this.addNative("getSelectedElementNum", 100, 0);
        this.addNative("getSelectedItemStack", 101, 0);
        this.addNative("setSelectedElement", 102, 1);
        this.addNative("getItemStackAt", 103, 1);
        this.addNative("setItemStackAt", 104, 2);
        this.addNative("getFastSlotSize", 105, 0);
    }

    public InventoryPlayer(ServerGame server) {
        this();
        this.server = server;
    }

    public int getSelectedElementNum() {
        return this.selectedElement;
    }

    public InvItemStack getSelectedItemStack() {
        return this.elementsList[this.selectedElement];
    }

    public void setSelectedElement(int element) {
        this.selectedElement = element;
    }

    public InvItemStack getItemStackAt(int index) {
        if (index < 0 || index >= this.elementsList.length) {
            return null;
        }
        return this.elementsList[index];
    }

    public void setItemStackAt(int index, InvItemStack itemStack) {
        if (index < 0 || index >= this.elementsList.length) {
            return;
        }
        this.elementsList[index] = itemStack == null || itemStack.stackSize == 0 || itemStack.itemID == 0 ? null : itemStack;
        if (this.server != null) {
            this.server.playerInventoryChanged(index, itemStack);
        }
    }

    public int getFastSlotSize() {
        return 3;
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 100: {
                stack.setInt(sp, this.getSelectedElementNum());
                break;
            }
            case 101: {
                stack.setObject(sp, (Object)this.getSelectedItemStack());
                break;
            }
            case 102: {
                this.setSelectedElement(stack.getInt(sp + 2));
                break;
            }
            case 103: {
                stack.setObject(sp, (Object)this.getItemStackAt(stack.getInt(sp + 2)));
                break;
            }
            case 104: {
                this.setItemStackAt(stack.getInt(sp + 2), (InvItemStack)stack.getObject(sp + 3));
                break;
            }
            case 105: {
                stack.setInt(sp, this.getFastSlotSize());
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

