/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.lcdui.Image;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiScreenSlotHost;
import net.comcraft.src.Keyboard;
import net.comcraft.src.Touch;

public abstract class GuiSlot
extends GuiElement {
    protected GuiScreenSlotHost guiScreenSlotHost;
    protected int slotScreenWidth;
    protected int slotScreenHeight;
    protected int slotWidth;
    protected int slotHeight;
    protected int xPos;
    protected int yPos;
    protected Comcraft cc;
    protected int amountScrolled;
    protected int selectedElement;
    private boolean handleInput;

    public GuiSlot(GuiScreenSlotHost guiScreenSlotHost) {
        this.guiScreenSlotHost = guiScreenSlotHost;
        this.cc = null;
        this.handleInput = true;
    }

    public final void resetSlot() {
        this.selectedElement = Touch.isTouchSupported() ? -1 : 0;
        this.guiScreenSlotHost.elementClicked(this.selectedElement);
        this.amountScrolled = this.getSize() * this.slotHeight >= this.slotScreenHeight ? -5 : -(this.slotScreenHeight / 2 - this.getSize() * this.slotHeight / 2);
    }

    public int getSlotEndPosY() {
        return this.yPos + this.slotScreenHeight;
    }

    public void initSlotScreen(Comcraft cc) {
        this.cc = cc;
        this.initSlotSize();
        this.initSlot();
    }

    protected abstract void initSlot();

    protected abstract void initSlotSize();

    public void setHandleInput(boolean flag) {
        this.handleInput = flag;
    }

    public boolean isInputHandle() {
        return this.handleInput;
    }

    private void drawBackground() {
        this.guiScreenSlotHost.drawDarkBackground();
    }

    protected void drawForeground() {
        Image backgroundImage = this.cc.textureProvider.getImage("gui/background.png");
        int cols = Comcraft.screenWidth / backgroundImage.getWidth() + 1;
        int i = 0;
        while (i < cols) {
            this.cc.g.drawImage(backgroundImage, i * backgroundImage.getWidth(), this.yPos, 36);
            ++i;
        }
        int yStart = this.slotScreenHeight + this.yPos;
        int rows = (Comcraft.screenHeight - yStart) / backgroundImage.getHeight() + 1;
        int y = 0;
        while (y < rows) {
            int x = 0;
            while (x < cols) {
                this.cc.g.drawImage(backgroundImage, x * backgroundImage.getWidth(), yStart + y * backgroundImage.getHeight(), 20);
                ++x;
            }
            ++y;
        }
    }

    protected abstract void drawSlot(int var1);

    private void elementClicked(int i) {
        this.selectedElement = i;
        this.guiScreenSlotHost.elementClicked(i);
    }

    public void drawScreen() {
        this.drawBackground();
        int i = 0;
        while (i < this.getSize()) {
            this.drawSlot(i);
            ++i;
        }
        if (this.getSize() * this.slotHeight > this.slotScreenHeight) {
            this.drawScrollBar();
        }
        this.drawForeground();
    }

    private void drawScrollBar() {
        int scrollBarHeight = this.slotScreenHeight / this.getSize();
        float floatAmountScrolled = (float)this.amountScrolled / (float)(this.getSize() * this.slotHeight - this.slotScreenHeight);
        int y = (int)((float)this.yPos + (float)this.slotScreenHeight * floatAmountScrolled);
        if (y < this.yPos) {
            y = this.yPos;
        } else if (y > this.yPos + this.slotScreenHeight - scrollBarHeight) {
            y = this.yPos + this.slotScreenHeight - scrollBarHeight;
        }
        this.cc.g.setColor(215, 215, 215);
        this.cc.g.fillRect(this.slotScreenWidth - 10, y, 5, scrollBarHeight);
    }

    protected int getClickedElementId(int y) {
        int yFx = y - this.yPos + this.amountScrolled;
        float id = (float)yFx / (float)this.slotHeight;
        if (id < 0.0f) {
            return -1;
        }
        return (int)id;
    }

    private void centerScreenAtSlot(int id) {
        if (id < 0 || id >= this.getSize()) {
            return;
        }
        int y = id * this.slotHeight - this.amountScrolled + this.yPos;
        if (y <= this.yPos) {
            this.amountScrolled -= this.slotHeight + 15;
        } else if (y + this.slotHeight >= this.yPos + this.slotScreenHeight) {
            this.amountScrolled += this.slotHeight + 15;
        }
    }

    protected void handleTouchInput() {
        if (this.isMousePressedAtScreen(Touch.getX(), Touch.getY())) {
            if (Touch.isPressed() && Touch.wasUnpressed()) {
                this.elementClicked(this.getClickedElementId(Touch.getY()));
            }
            if (Touch.isDragged()) {
                this.scrollSlot(Touch.getTouchYDifference());
            }
        }
    }

    protected void handleKeyboardInput() {
        if (Keyboard.wasButtonDown(-2)) {
            this.selectedElement = this.getCorrectSelectedElementId(this.selectedElement + 1);
            this.centerScreenAtSlot(this.selectedElement);
            this.elementClicked(this.selectedElement);
        }
        if (Keyboard.wasButtonDown(-1)) {
            this.selectedElement = this.getCorrectSelectedElementId(this.selectedElement - 1);
            this.centerScreenAtSlot(this.selectedElement);
            this.elementClicked(this.selectedElement);
        }
    }

    private int getCorrectSelectedElementId(int id) {
        if (id >= this.getSize()) {
            return this.getSize() - 1;
        }
        if (id < 0) {
            return 0;
        }
        return id;
    }

    public void handleInput() {
        if (this.handleInput) {
            this.handleKeyboardInput();
        }
        this.handleTouchInput();
    }

    protected int getSize() {
        return this.guiScreenSlotHost.getElementsList().size();
    }

    protected void drawSelectedSlotFrame(int y) {
        this.cc.g.setColor(0, 0, 0);
        this.cc.g.fillRect((Comcraft.screenWidth - this.slotWidth) / 2, y, this.slotWidth, this.slotHeight);
        this.cc.g.setColor(128, 128, 128);
        int i = 0;
        while (i < 3) {
            this.cc.g.drawRect((Comcraft.screenWidth - this.slotWidth) / 2 - i, y - i, this.slotWidth + i * 2, this.slotHeight + i * 2);
            ++i;
        }
    }

    private void scrollSlot(int i) {
        if (this.getSize() * this.slotHeight <= this.slotScreenHeight) {
            return;
        }
        this.amountScrolled += i;
        if (this.amountScrolled < -15) {
            this.amountScrolled = -15;
        } else if (this.amountScrolled > this.getSize() * this.slotHeight + 15 - this.slotScreenHeight) {
            this.amountScrolled = this.getSize() * this.slotHeight + 15 - this.slotScreenHeight;
        }
    }

    protected boolean isMousePressedAtScreen(int x, int y) {
        return x >= this.xPos && y >= this.yPos && x <= this.xPos + this.slotScreenWidth && y <= this.yPos + this.slotScreenHeight;
    }

    protected boolean isSlotVisibile(int y) {
        return y + this.slotHeight >= this.yPos && y <= this.yPos + this.slotScreenHeight;
    }

    protected int getSlotY(int i) {
        return i * this.slotHeight - this.amountScrolled + this.yPos;
    }
}

