/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiLoadingScreen;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiScreenSlotHost;
import net.comcraft.src.GuiSlotSelectTexturepack;
import net.comcraft.src.TexturePack;

public final class GuiSelectTexturepack
extends GuiScreenSlotHost {
    private TexturePack selectedTexturePack;

    public GuiSelectTexturepack(GuiScreen parentScreen) {
        super(parentScreen, "SelectTexturepack");
        this.guiSlot = new GuiSlotSelectTexturepack(this);
    }

    protected void initGuiSlotCustom() {
        this.cc.texturePackList.updateAvailableTexturePacks();
        this.addButton(this.cc.langBundle.getText("GuiScreen.buttonSelect"), false, 0, 0);
        this.addButton(this.cc.langBundle.getText("GuiScreen.buttonClose"), this.parentScreen != null, 0, 1);
        this.elementClicked(0);
    }

    public void onScreenClosed() {
    }

    public void elementClicked(int id) {
        if (id >= this.getElementsList().size() || id < 0) {
            this.getButton(0).setEnabled(false);
            this.selectedTexturePack = null;
            return;
        }
        TexturePack texturePack = (TexturePack)this.getElementsList().elementAt(id);
        if (this.checkTexturepack(texturePack)) {
            this.getButton(0).setEnabled(true);
            this.selectedTexturePack = texturePack;
        } else {
            this.getButton(0).setEnabled(false);
            this.selectedTexturePack = null;
        }
    }

    private boolean checkTexturepack(TexturePack texturePack) {
        return texturePack.isTexturePackSupported();
    }

    public Vector getElementsList() {
        return this.cc.texturePackList.getTexturepacksList();
    }

    protected void customDrawScreen() {
        this.guiSlot.drawScreen();
        this.drawTitle(String.valueOf(this.cc.langBundle.getText("GuiSelectTexturepack.title")) + " (" + Comcraft.getScreenWidth() + "x" + Comcraft.getScreenHeight() + ")");
    }

    private void loadTexturePack(TexturePack selectedTexturePack) {
        GuiLoadingScreen guiScreen = new GuiLoadingScreen();
        guiScreen.initGuiScreen(this.cc);
        guiScreen.drawScreen();
        this.cc.flushGraphics();
        this.cc.texturePackList.setTexturePack(selectedTexturePack);
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.id == 0) {
            this.loadTexturePack(this.selectedTexturePack);
            this.backToParentScreen();
        } else if (guiButton.id == 1) {
            this.backToParentScreen();
        }
    }
}

