/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import net.comcraft.src.ComcraftFileSystem;
import net.comcraft.src.FileBrowser;
import net.comcraft.src.FileSystemHelper;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiMainMenu;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiScreenSlotHost;
import net.comcraft.src.GuiSlotSelectPath;
import net.comcraft.src.GuiYesNo;
import net.comcraft.src.GuiYesNoHost;
import net.comcraft.src.Touch;

public class GuiSelectPath
extends GuiScreenSlotHost
implements GuiYesNoHost {
    private String selectedPath;
    private FileBrowser fileBrowser;
    private String memoryCardRoot;

    public GuiSelectPath(GuiScreen parentScreen) {
        super(parentScreen, "SelectPath");
        this.guiSlot = new GuiSlotSelectPath(this);
        this.fileBrowser = new FileBrowser();
    }

    public void customDrawScreen() {
        this.guiSlot.drawScreen();
        this.cc.g.setColor(255, 255, 255);
        GuiElement.drawStringWithShadow(this.cc.g, FileSystemHelper.getPathWithoutPrefix(this.fileBrowser.getCurrentPath()), 5, 3, 20);
    }

    protected void initGuiSlotCustom() {
        if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
            this.fileBrowser.openDirectory("file:///");
            this.checkForMemoryCard();
        } else {
            this.fileBrowser.openDirectory(this.cc.settings.getComcraftFileSystem().getComcraftPath());
        }
        this.addButton(this.cc.langBundle.getText("GuiSelectPath.buttonOpen"), false, 1, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectPath.buttonBack"), !this.fileBrowser.getCurrentPath().equals("file:///"), 1, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectPath.buttonSetAsRoot"), this.fileBrowser.canWriteCurrentDirectory(), 0, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectPath.buttonClose"), this.parentScreen != null, 0, 1);
        this.elementClicked(0);
    }

    private void checkForMemoryCard() {
        Vector roots = this.getElementsList();
        if (roots.contains("file:///Mmc/")) {
            this.memoryCardRoot = "file:///Mmc/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///MemoryCard/")) {
            this.memoryCardRoot = "file:///MemoryCard/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///e/")) {
            this.memoryCardRoot = "file:///e/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///e:/")) {
            this.memoryCardRoot = "file:///e:/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///E/")) {
            this.memoryCardRoot = "file:///E/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///E:/")) {
            this.memoryCardRoot = "file:///E:/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        } else if (roots.contains("file:///M:/")) {
            this.memoryCardRoot = "file:///M:/";
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectPatch.useMMC.confirmationText")));
        }
    }

    public void elementClicked(int id) {
        String path;
        if (id >= this.getElementsList().size() || id < 0) {
            this.getButton(0).setEnabled(false);
            this.selectedPath = "";
            return;
        }
        this.selectedPath = path = (String)this.getElementsList().elementAt(id);
        this.getButton(0).setEnabled(FileSystemHelper.isDirectory(this.selectedPath));
    }

    private void reset() {
        this.selectedPath = this.getElementsList().isEmpty() || Touch.isTouchSupported() ? "" : (String)this.getElementsList().firstElement();
        this.guiSlot.setHandleInput(true);
        this.selectedButton = null;
        this.guiSlot.resetSlot();
    }

    private void checkCurrentFolder() {
        this.getButton(0).setEnabled(FileSystemHelper.isDirectory(this.selectedPath));
        this.getButton(1).setEnabled(!this.fileBrowser.getCurrentPath().equals("file:///"));
        this.getButton(2).setEnabled(this.fileBrowser.canWriteCurrentDirectory());
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.getId() == 0) {
            this.fileBrowser.openDirectory(this.selectedPath);
            this.reset();
            this.checkCurrentFolder();
        } else if (guiButton.getId() == 1) {
            this.fileBrowser.openPreviousFolder();
            this.reset();
            this.checkCurrentFolder();
        } else if (guiButton.getId() == 2) {
            if (this.setAsRoot()) {
                this.backToParentScreen();
            }
        } else if (guiButton.getId() == 3) {
            this.backToParentScreen();
        }
    }

    private boolean setAsRoot() {
        ComcraftFileSystem comcraftFileSystem;
        try {
            comcraftFileSystem = new ComcraftFileSystem(this.cc, this.fileBrowser.getCurrentPath());
        }
        catch (SecurityException ex) {
            return false;
        }
        this.cc.settings.setComcraftFileSystem(comcraftFileSystem);
        return true;
    }

    public Vector getElementsList() {
        return this.fileBrowser.getCurrentElements();
    }

    public void onScreenClosed() {
    }

    public void guiYesNoAction(boolean value) {
        if (value) {
            if (this.memoryCardRoot == null) {
                return;
            }
            this.fileBrowser.openDirectory(this.memoryCardRoot);
            this.setAsRoot();
            this.cc.displayGuiScreen(new GuiMainMenu());
        }
    }
}

