/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiButtonSelect;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiSelectWorld;
import net.comcraft.src.WorldGenerator;
import net.comcraft.src.WorldSaveType;

public class GuiNewWorld
extends GuiScreen {
    private GuiScreen guiMainMenu;
    private boolean allowcommands;

    public GuiNewWorld(GuiScreen parentScreen, GuiScreen guiMainMenu) {
        super(parentScreen, "NewWorld");
        this.guiMainMenu = guiMainMenu;
    }

    protected void customDrawScreen() {
    }

    protected void initGui() {
        int centerX = (Comcraft.screenWidth - GuiButton.getButtonWidth()) / 2;
        int startY = 30;
        this.elementsList.addElement(new GuiButton(this.cc, 0, centerX, startY, this.cc.langBundle.getText("GuiNewWorld.buttonCreate")));
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.elementsList.addElement(new GuiButtonSelect(this.cc, 2, centerX, startY + (GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6) * 2, this.cc.langBundle.getText("GuiNewWorld.worldType"), nArray, new String[]{this.cc.langBundle.getText("GuiNewWorld.worldType.normal"), this.cc.langBundle.getText("GuiNewWorld.worldType.flat")}));
        this.elementsList.addElement(new GuiButtonSelect(this.cc, 4, centerX, startY + (GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6) * 3, this.cc.langBundle.getText("GuiNewWorld.size"), new int[]{16, 32, 64, 256}, new String[]{this.cc.langBundle.getText("GuiNewWorld.size.normal"), this.cc.langBundle.getText("GuiNewWorld.size.big"), this.cc.langBundle.getText("GuiNewWorld.size.bigger"), this.cc.langBundle.getText("GuiNewWorld.size.biggest")}));
        this.elementsList.addElement(new GuiButtonSelect(this.cc, 3, centerX, startY + (GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6) * 4, this.cc.langBundle.getText("GuiNewWorld.level"), new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12 (default)", "13", "14", "15"}).setCurrentValue(12).setEnabled(false));
        this.elementsList.addElement(new GuiButton(this.cc, 6, centerX, startY + (GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6) * 5, this.cc.langBundle.getText("GuiNewWorld.command.enable")));
        this.elementsList.addElement(new GuiButton(this.cc, 1, centerX, startY + (GuiButton.getButtonHeight() + GuiButton.getButtonHeight() / 6) * 7, this.cc.langBundle.getText("GuiNewWorld.buttonClose")).setEnabled(this.parentScreen != null));
        this.allowcommands = false;
    }

    public void onScreenClosed() {
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        this.eh.runEvent("handleGuiAction", this, new Object[]{guiButton});
        if (guiButton.getId() == 0) {
            this.generateWorld();
            this.cc.displayGuiScreen(new GuiSelectWorld(this.guiMainMenu));
        } else if (guiButton.getId() == 1) {
            this.backToParentScreen();
        } else if (guiButton.getId() == 2) {
            GuiButtonSelect guiButtonSelect = this.getButtonSelect(guiButton.getId());
            guiButtonSelect.nextValue();
            if (guiButtonSelect.getCurrentValue() == 1) {
                this.getButton(3).setEnabled(true);
            } else {
                this.getButton(3).setEnabled(false);
            }
        } else if (guiButton.getId() == 3) {
            GuiButtonSelect guiButtonSelect = this.getButtonSelect(guiButton.getId());
            guiButtonSelect.nextValue();
        } else if (guiButton.getId() == 4) {
            GuiButtonSelect guiButtonSelect = this.getButtonSelect(guiButton.getId());
            guiButtonSelect.nextValue();
        } else if (guiButton.getId() == 5) {
            boolean value = !this.getButtonOnOff(guiButton.getId()).getValue();
            this.getButtonOnOff(guiButton.getId()).setValue(value);
        } else if (guiButton.getId() == 6) {
            if (this.allowcommands) {
                guiButton.displayString = this.cc.langBundle.getText("GuiNewWorld.command.enable");
                this.allowcommands = false;
            } else {
                guiButton.displayString = this.cc.langBundle.getText("GuiNewWorld.command.disable");
                this.allowcommands = true;
            }
        }
    }

    private boolean isWorldWithTheSameName(String name) {
        int i = 0;
        while (i < this.cc.worldLoader.getWorldList().size()) {
            WorldSaveType worldSaveType = (WorldSaveType)this.cc.worldLoader.getWorldList().elementAt(i);
            if (worldSaveType.getWorldName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void generateWorld() {
        String name;
        int i = 1;
        while (true) {
            if (!this.isWorldWithTheSameName(name = "World " + i)) break;
            ++i;
        }
        String worldName = name;
        int worldSize = this.getButtonSelect(4).getCurrentValue();
        boolean isFlat = this.getButtonSelect(2).getCurrentValue() == 1;
        int flatLevel = this.getButtonSelect(3).getCurrentValue();
        WorldGenerator worldGenerator = new WorldGenerator(this.cc, worldName, worldSize, isFlat, flatLevel, false);
        worldGenerator.generateAndSaveWorld(this.allowcommands);
    }
}

