/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import java.util.Calendar;
import net.comcraft.client.Comcraft;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiElement;
import net.comcraft.src.GuiInfo;
import net.comcraft.src.GuiOptions;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiSelectMod;
import net.comcraft.src.GuiSelectServer;
import net.comcraft.src.GuiSelectTexturepack;
import net.comcraft.src.GuiSelectWorld;
import net.comcraft.src.GuiYesNo;
import net.comcraft.src.GuiYesNoHost;
import net.comcraft.src.Keyboard;
import net.comcraft.src.Touch;

public class GuiMainMenu
extends GuiScreen
implements GuiYesNoHost {
    private String currentHelloWord;
    private int logoHeight;
    private static final int ID_CALC_BTN_Y = 150;

    public GuiMainMenu() {
        super(null, "MainMenu");
        this.addNative("calcBtnY", 150, 1);
    }

    public void onScreenDisplay() {
        Touch.resetTouch();
        Keyboard.resetKeyboard();
    }

    public void customDrawScreen() {
        this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/comcraft_logo.png"), Comcraft.screenWidth / 2, 10, 17);
        this.cc.g.setColor(Short.MAX_VALUE);
        GuiElement.drawStringWithShadow(this.cc.g, this.currentHelloWord, 10, 13 + this.cc.textureProvider.getImage("gui/comcraft_logo.png").getHeight(), 20);
        this.cc.g.setColor(240, 240, 240);
        GuiElement.drawStringWithShadow(this.cc.g, "Copyright Piotr W\u00f3jcik.", Comcraft.screenWidth - 2, Comcraft.screenHeight - 2 - this.cc.g.getFont().getHeight() - 2, 40);
        GuiElement.drawStringWithShadow(this.cc.g, "Do not distribute!", Comcraft.screenWidth - 2, Comcraft.screenHeight - 2, 40);
    }

    protected void initGui() {
        this.currentHelloWord = this.getHelloWorld();
        this.logoHeight = this.cc.textureProvider.getImage("gui/comcraft_logo.png").getHeight();
        int centerX = (Comcraft.screenWidth - GuiButton.getButtonWidth()) / 2;
        this.elementsList.addElement(new GuiButton(this.cc, 0, centerX, this.calcBtnY(0), this.cc.langBundle.getText("GuiMainMenu.buttonSingleplayer")));
        this.elementsList.addElement(new GuiButton(this.cc, 6, centerX, this.calcBtnY(1), this.cc.langBundle.getText("GuiMainMenu.buttonMultiplayer")));
        this.elementsList.addElement(new GuiButton(this.cc, 1, centerX, this.calcBtnY(2), this.cc.langBundle.getText("GuiMainMenu.buttonTexturepacks")));
        this.elementsList.addElement(new GuiButton(this.cc, 5, centerX, this.calcBtnY(3), this.cc.langBundle.getText("GuiMainMenu.buttonMods")));
        this.elementsList.addElement(new GuiButton(this.cc, 2, centerX, this.calcBtnY(4), this.cc.langBundle.getText("GuiMainMenu.buttonOptions")));
        this.elementsList.addElement(new GuiButton(this.cc, 3, centerX, this.calcBtnY(5), this.cc.langBundle.getText("GuiMainMenu.buttonInfo")));
        this.elementsList.addElement(new GuiButton(this.cc, 4, centerX, this.calcBtnY(6), this.cc.langBundle.getText("GuiMainMenu.buttonQuit")));
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        if (id == 150) {
            stack.setInt(sp, this.calcBtnY(stack.getInt(sp + 2)));
        } else {
            super.evalNative(id, stack, sp, parCount);
        }
    }

    protected int calcBtnY(int i) {
        int startY = 10 + this.logoHeight + 30;
        return startY + (GuiButton.getButtonHeight() + (int)((float)GuiButton.getButtonHeight() * 0.35f)) * i;
    }

    private String getHelloWorld() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 1 && calendar.get(5) == 10) {
            return "Happy birthday Queader!";
        }
        if (calendar.get(2) == 11 && (calendar.get(5) == 24 || calendar.get(5) == 25 || calendar.get(5) == 26)) {
            return "Merry Christmas!";
        }
        if (calendar.get(2) == 3 && calendar.get(5) == 29) {
            return "Happy birthday Micha\u0142!";
        }
        if (calendar.get(2) == 11 && calendar.get(5) == 27) {
            return "Happy birthday Simon!";
        }
        return this.cc.helloWords.getRandomWord();
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        this.eh.runEvent("handleGuiAction", this, new Object[]{guiButton});
        if (guiButton.id == 0) {
            this.cc.displayGuiScreen(new GuiSelectWorld(this));
        } else if (guiButton.id == 1) {
            this.cc.displayGuiScreen(new GuiSelectTexturepack(this));
        } else if (guiButton.id == 2) {
            this.cc.displayGuiScreen(new GuiOptions(this));
        } else if (guiButton.id == 4) {
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiMainMenu.quitAction.confirmationText")));
        } else if (guiButton.id == 3) {
            this.cc.displayGuiScreen(new GuiInfo(this));
        } else if (guiButton.id == 5) {
            this.cc.displayGuiScreen(new GuiSelectMod(this));
        } else if (guiButton.id == 6) {
            this.cc.displayGuiScreen(new GuiSelectServer(this));
        }
    }

    public void guiYesNoAction(boolean value) {
        if (value) {
            this.cc.displayGuiScreen(null);
            this.cc.shutdown();
        }
    }
}

