/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.ChunkStorage;
import net.comcraft.src.RenderChunkPieces;
import net.comcraft.src.World;

public class Chunk {
    public final int xPos;
    public final int zPos;
    private ChunkStorage[] blockStorageArray;
    private World world;
    private boolean needsRegenereate;
    private RenderChunkPieces renderChunk;
    private boolean isEdited;

    public Chunk(World world, int chunkX, int chunkZ) {
        this.world = world;
        this.xPos = chunkX;
        this.zPos = chunkZ;
        this.blockStorageArray = new ChunkStorage[8];
        this.needsRegenereate = true;
        this.renderChunk = new RenderChunkPieces(world, this);
    }

    public void scanChunk() {
        int z = 0;
        while (z < 4) {
            int y = 0;
            while (y < 32) {
                int x = 0;
                while (x < 4) {
                    if (Block.blocksList[this.getBlockID(x, y, z)] != null && Block.blocksList[this.getBlockID(x, y, z)].isUpdatableBlock()) {
                        this.world.getWorldUpdater().addBlockUpdatable(x + (this.xPos << 2), y, z + (this.zPos << 2));
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
    }

    public boolean isEdited() {
        return this.isEdited;
    }

    public RenderChunkPieces getRenderChunk() {
        if (this.xPos - 1 >= 0 && this.world.getChunkFromChunkCoords(this.xPos - 1, this.zPos).isEmptyChunk()) {
            return null;
        }
        if (this.xPos + 1 < this.world.worldSize && this.world.getChunkFromChunkCoords(this.xPos + 1, this.zPos).isEmptyChunk()) {
            return null;
        }
        if (this.zPos - 1 >= 0 && this.world.getChunkFromChunkCoords(this.xPos, this.zPos - 1).isEmptyChunk()) {
            return null;
        }
        if (this.zPos + 1 < this.world.worldSize && this.world.getChunkFromChunkCoords(this.xPos, this.zPos + 1).isEmptyChunk()) {
            return null;
        }
        if (this.needsRegenereate) {
            this.renderChunk.regenereatePieces();
            this.needsRegenereate = false;
        }
        return this.renderChunk;
    }

    public ChunkStorage[] getBlockStorageArray() {
        return this.blockStorageArray;
    }

    public void setBlockStorageArray(ChunkStorage[] blockStorage) {
        this.blockStorageArray = blockStorage;
    }

    public int getBlockID(int x, int y, int z) {
        return this.blockStorageArray[y >> 2].getBlockID(x, y & 3, z);
    }

    public boolean setBlockID(int x, int y, int z, int id) {
        return this.setBlockIDWithMetadata(x, y, z, id, 0);
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.blockStorageArray[y >> 2].getBlockMetadata(x, y & 3, z);
    }

    public boolean setBlockMetadata(int x, int y, int z, int metadata) {
        this.isEdited = true;
        ChunkStorage blockStorage = this.blockStorageArray[y >> 2];
        if (blockStorage == null) {
            return false;
        }
        int i = blockStorage.getBlockMetadata(x, y & 3, z);
        if (i == metadata) {
            return false;
        }
        blockStorage.setBlockMetadata(x, y & 3, z, metadata);
        return true;
    }

    public boolean setBlockIDWithMetadata(int x, int y, int z, int id, int metadata) {
        this.isEdited = true;
        this.needsRegenereate = true;
        if (x == 0) {
            this.world.getChunkFromChunkCoords((int)(this.xPos - 1), (int)this.zPos).needsRegenereate = true;
        } else if (x == 3) {
            this.world.getChunkFromChunkCoords((int)(this.xPos + 1), (int)this.zPos).needsRegenereate = true;
        }
        if (z == 0) {
            this.world.getChunkFromChunkCoords((int)this.xPos, (int)(this.zPos - 1)).needsRegenereate = true;
        } else if (z == 3) {
            this.world.getChunkFromChunkCoords((int)this.xPos, (int)(this.zPos + 1)).needsRegenereate = true;
        }
        int lastID = this.getBlockID(x, y, z);
        ChunkStorage blockStorage = this.blockStorageArray[y >> 2];
        if (blockStorage == null) {
            if (id == 0) {
                return false;
            }
            ChunkStorage chunkStorage = new ChunkStorage();
            this.blockStorageArray[y >> 2] = chunkStorage;
            blockStorage = chunkStorage;
        }
        if (this.world.chunkProvider.isServerGame) {
            this.world.cc.serverLoader.game.blockChanged(this, x, y, z, id, metadata);
        }
        blockStorage.setBlockID(x, y & 3, z, id);
        if (lastID != 0) {
            Block.blocksList[lastID].onBlockRemoval(this.world, (this.xPos << 2) + x, y, (this.zPos << 2) + z);
        }
        blockStorage.setBlockMetadata(x, y & 3, z, metadata);
        if (id != 0) {
            Block.blocksList[id].onBlockAdded(this.world, (this.xPos << 2) + x, y, (this.zPos << 2) + z);
        }
        return true;
    }

    public boolean isEmptyChunk() {
        return false;
    }
}

