/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.ModelPieceSlab;
import net.comcraft.src.World;

public class BlockSlab
extends Block {
    private int indexSides;
    private int indexTopDown;

    public BlockSlab(int id, int indexSides, int indexTopDown) {
        super(id, -1);
        this.indexSides = indexSides;
        this.indexTopDown = indexTopDown;
    }

    public BlockSlab(int id, int index) {
        this(id, index, index);
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexSides, this.indexTopDown};
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public VertexBuffer[][][][] getBlockVertexBufferPieced(World world, int x, int y, int z) {
        return ModelPieceSlab.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelPieceSlab.indexBuffer;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (side > 3) {
            return this.indexTopDown;
        }
        return this.indexSides;
    }

    public boolean isNormal() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 0.5f, (float)z + 1.0f);
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        int i = world.getBlockID(x, y, z);
        return i == this.blockID || i == 0;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return !world.isBlockNormal(x, y, z) || side == 4;
    }
}

