/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.World;

public class BlockFurnance
extends Block {
    private int indexFront;
    private int indexSide;
    private int indexTop;
    private int indexBottom;
    private int indexActivated;

    public BlockFurnance(int id, int indexFront, int indexSide, int indexTop, int indexBottom, int indexActivated) {
        super(id);
        this.indexFront = indexFront;
        this.indexSide = indexSide;
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
        this.indexActivated = indexActivated;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexFront, this.indexSide, this.indexTop, this.indexBottom, this.indexActivated};
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        this.changeFurnanceState(world, x, y, z);
        return true;
    }

    public boolean canBePieced() {
        return false;
    }

    public int getRenderType() {
        return 0;
    }

    private boolean isFurnanceActivated(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        return world.getBlockMetadata(x, y, z) >> 4 == 1;
    }

    private void changeFurnanceState(World world, int x, int y, int z) {
        int prevMetadata = world.getBlockMetadata(x, y, z);
        int side = prevMetadata & 0xF;
        int state = prevMetadata >> 4 == 1 ? 0 : 1;
        world.setBlockMetadata(x, y, z, side | state << 4);
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world != null && side == (world.getBlockMetadata(x, y, z) & 0xF) || world == null && side == 0) {
            if (this.isFurnanceActivated(world, x, y, z)) {
                return this.indexActivated;
            }
            return this.indexFront;
        }
        if (side == 4) {
            return this.indexTop;
        }
        if (side == 5) {
            return this.indexBottom;
        }
        return this.indexSide;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata = entityPlayer.rotationYaw >= 45.0f && entityPlayer.rotationYaw <= 135.0f ? 3 : (entityPlayer.rotationYaw >= 135.0f && entityPlayer.rotationYaw <= 225.0f ? 1 : (entityPlayer.rotationYaw >= 225.0f && entityPlayer.rotationYaw <= 315.0f ? 2 : 0));
        world.setBlockMetadata(x, y, z, metadata);
    }
}

