/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.World;

public class BlockAnimal
extends Block {
    private int indexFront;
    private int indexBack;
    private int indexSides;
    private int indexTop;
    private int indexBottom;

    public BlockAnimal(int id, int indexFront, int indexBack, int indexSides, int indexTop, int indexBottom) {
        super(id);
        this.indexFront = indexFront;
        this.indexBack = indexBack;
        this.indexSides = indexSides;
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexFront, this.indexBack, this.indexSides, this.indexTop, this.indexBottom};
    }

    public int getRenderType() {
        return 0;
    }

    public boolean canBePieced() {
        return false;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world == null && side == 0) {
            return this.indexFront;
        }
        if (world == null && side == 4) {
            return this.indexTop;
        }
        if (world == null) {
            return this.indexSides;
        }
        int blockSide = world.getBlockMetadata(x, y, z);
        if (side == blockSide) {
            return this.indexFront;
        }
        if (side == 4) {
            return this.indexTop;
        }
        if (side == 5) {
            return this.indexBottom;
        }
        if (side == 0 && blockSide == 1 || side == 1 && blockSide == 0 || side == 2 && blockSide == 3 || side == 3 && blockSide == 2) {
            return this.indexBack;
        }
        return this.indexSides;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata = entityPlayer.rotationYaw >= 45.0f && entityPlayer.rotationYaw <= 135.0f ? 3 : (entityPlayer.rotationYaw >= 135.0f && entityPlayer.rotationYaw <= 225.0f ? 1 : (entityPlayer.rotationYaw >= 225.0f && entityPlayer.rotationYaw <= 315.0f ? 2 : 0));
        world.setBlockMetadata(x, y, z, metadata);
    }
}

