/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class CRunTime {
    public static int[] memory;
    public static int saved_v1;
    public static int ra;
    public static int eventStackPointer;
    public static Object[] objectRepository;
    private static int maxRepositoryObjects;
    private static int firstFree;
    private static Hashtable callbacksByName;
    private static int functionNesting;

    public static final void init(InputStream inputStream, int n) throws Exception {
        maxRepositoryObjects = 256;
        callbacksByName = new Hashtable();
        objectRepository = new Object[maxRepositoryObjects];
        CRunTime.objectRepository[0] = null;
        firstFree = 2;
        memory = new int[n / 4];
        int n2 = inputStream.available() / 4;
        for (int i = 0; i < n2; ++i) {
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            CRunTime.memory[i] = (n3 & 0xFF) << 24 | (n4 & 0xFF) << 16 | (n5 & 0xFF) << 8 | n6 & 0xFF;
        }
        CRunTime.memory[1] = CibylConfig.stackSize;
        CRunTime.memory[3] = n - (CibylConfig.eventStackSize - 8);
    }

    public static final void init(InputStream inputStream) throws Exception {
        memory = null;
        objectRepository = null;
        System.gc();
        int n = (int)((float)Runtime.getRuntime().freeMemory() * CibylConfig.cibylMemoryProportion);
        if (CibylConfig.memorySize != 0) {
            n = CibylConfig.memorySize;
        }
        if (CibylConfig.faultMemoryIn) {
            n = (int)CRunTime.faultMemoryIn(CibylConfig.memorySize);
        }
        n -= n & 7;
        eventStackPointer = n - 8;
        int n2 = inputStream.available() / 4;
        if (n2 < 5) {
            throw new Exception("Data input is too small");
        }
        CRunTime.init(inputStream, n);
    }

    private static final long faultMemoryIn(int n) {
        long l = 0L;
        Vector<int[]> vector = new Vector<int[]>(1024, 256);
        int n2 = 0;
        try {
            System.gc();
            while (n2 < n / 1024) {
                int[] nArray = new int[256];
                vector.addElement(nArray);
                ++n2;
                l += 1024L;
            }
        }
        catch (Throwable throwable) {
            vector = null;
            l = Runtime.getRuntime().totalMemory();
            System.gc();
        }
        return l;
    }

    public static Object getRegisteredObject(int n) {
        return objectRepository[n];
    }

    public static int registerObject(Object object) {
        int n;
        int n2 = firstFree;
        if (object == null) {
            return 0;
        }
        CRunTime.objectRepository[n2] = object;
        for (n = firstFree; n < objectRepository.length; ++n) {
            if (objectRepository[n] != null) continue;
            firstFree = n;
            return n2;
        }
        if (n == objectRepository.length) {
            Object[] objectArray = new Object[maxRepositoryObjects *= 2];
            for (n = 0; n < objectRepository.length; ++n) {
                objectArray[n] = objectRepository[n];
            }
            objectArray[n] = object;
            objectRepository = objectArray;
            n2 = n;
        }
        return n2;
    }

    public static Object deRegisterObject(int n) {
        Object object = CRunTime.getRegisteredObject(n);
        if (firstFree > n) {
            firstFree = n;
        }
        CRunTime.objectRepository[n] = null;
        return object;
    }

    public static int publishCallback(String string) {
        int n = CRunTime.registerObject(new Integer(0));
        Integer n2 = new Integer(n);
        callbacksByName.put(string, n2);
        return n;
    }

    public static int registerCallback(int n, int n2) {
        String string = CRunTime.charPtrToString(n);
        Integer n3 = (Integer)callbacksByName.get(string);
        Integer n4 = (Integer)objectRepository[n3];
        CRunTime.objectRepository[n3.intValue()] = new Integer(n2);
        return n4;
    }

    public static long invokeCallback(int n, int n2, int n3, int n4, int n5) throws Exception {
        Integer n6 = (Integer)objectRepository[n];
        if (n6 == 0) {
            return 0L;
        }
        return CibylCallTable.call(n6, eventStackPointer, n2, n3, n4, n5);
    }

    public static String charPtrToString(int n) {
        int n2 = n;
        int n3 = 0;
        int n4 = 0;
        while (CRunTime.memoryReadByte(n2 + n4) != 0) {
            ++n4;
        }
        if (n4 == 0) {
            return "";
        }
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n3] = (byte)CRunTime.memoryReadByte(n2 + n3);
        }
        try {
            String string = CibylConfig.stringEncoding == null ? new String(byArray) : new String(byArray, CibylConfig.stringEncoding);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static final void memoryWriteByte(int n, int n2) {
        int n3 = n2 & 0xFF;
        int n4 = memory[n / 4];
        int n5 = 3 - (n & 3) << 3;
        n4 &= ~(255 << n5);
        CRunTime.memory[n / 4] = n4 |= n3 << n5;
    }

    public static final void memoryWriteShort(int n, int n2) {
        int n3 = n2 & 0xFFFF;
        int n4 = memory[n / 4];
        int n5 = 2 - (n & 2) << 3;
        n4 &= ~(65535 << n5);
        CRunTime.memory[n / 4] = n4 |= n3 << n5;
    }

    public static final void memoryWriteWord(int n, int n2) {
        CRunTime.memory[n / 4] = n2;
    }

    public static final void memoryWriteLong(int n, long l) {
        CRunTime.memory[n >> 2] = (int)(l >> 32);
        CRunTime.memory[n + 4 >> 2] = (int)(l & 0xFFFFFFFFL);
    }

    public static final void memoryWriteBytePc(int n, int n2, int n3) {
        CRunTime.assertMemoryWrite("1-byte", n, n2, n3);
        CRunTime.memoryWriteByte(n2, n3);
    }

    public static final void memoryWriteShortPc(int n, int n2, int n3) {
        CRunTime.assertMemoryWrite("2-byte", n, n2, n3);
        CRunTime.memoryWriteShort(n2, n3);
    }

    public static final void memoryWriteWordPc(int n, int n2, int n3) {
        CRunTime.assertMemoryWrite("4-byte", n, n2, n3);
        CRunTime.memoryWriteWord(n2, n3);
    }

    public static final long memoryReadLong(int n) {
        long l = (long)memory[n + 4 >> 2] & 0xFFFFFFFFL;
        long l2 = (long)memory[n >> 2] & 0xFFFFFFFFL;
        long l3 = l2 << 32 | l;
        return l3;
    }

    public static final int memoryReadWord(int n) {
        return memory[n >> 2];
    }

    public static final int memoryReadByteUnsigned(int n) {
        int n2 = memory[n >> 2];
        int n3 = 3 - (n & 3) << 3;
        return n2 >>> n3 & 0xFF;
    }

    public static final int memoryReadByte(int n) {
        int n2 = memory[n >> 2];
        int n3 = 3 - (n & 3) << 3;
        int n4 = n2 >>> n3 & 0xFF;
        if ((n4 & 0x80) != 0) {
            return n4 | 0xFFFFFF00;
        }
        return n4;
    }

    public static final int memoryReadShortUnsigned(int n) {
        int n2 = memory[n >> 2];
        int n3 = 2 - (n & 2) << 3;
        return n2 >>> n3 & 0xFFFF;
    }

    public static final int memoryReadShort(int n) {
        int n2 = CRunTime.memoryReadShortUnsigned(n);
        if ((n2 & 0x8000) != 0) {
            return n2 | 0xFFFF0000;
        }
        return n2;
    }

    public static final void memcpy(int n, byte[] byArray, int n2, int n3) {
        int n4;
        while ((n & 3) != 0 && n3 > 0) {
            n4 = byArray[n2++];
            CRunTime.memoryWriteByte(n, n4);
            ++n;
            if (--n3 != 0) continue;
            return;
        }
        while (n3 > 3) {
            n4 = 0;
            for (int i = 0; i < 4; ++i) {
                n4 <<= 8;
                int n5 = byArray[n2++] & 0xFF;
                n4 |= n5;
            }
            CRunTime.memoryWriteWord(n, n4);
            n += 4;
            n3 -= 4;
        }
        while (n3 > 0) {
            n4 = byArray[n2++];
            CRunTime.memoryWriteByte(n, n4);
            ++n;
            --n3;
        }
    }

    public static final void memcpy(byte[] byArray, int n, int n2, int n3) {
        while (n3 > 0) {
            byArray[n++] = (byte)CRunTime.memoryReadByte(n2);
            ++n2;
            --n3;
        }
    }

    public static final int memoryReadWordLeft(int n) {
        int n2 = CRunTime.memoryReadByteUnsigned(n + 3);
        int n3 = CRunTime.memoryReadByteUnsigned(n + 2);
        int n4 = CRunTime.memoryReadByteUnsigned(n + 1);
        int n5 = CRunTime.memoryReadByteUnsigned(n + 0);
        return n2 | n3 << 8 | n4 << 16 | n5 << 24;
    }

    public static final void memoryWriteWordLeft(int n, int n2) {
        CRunTime.memoryWriteByte(n + 3, n2);
        CRunTime.memoryWriteByte(n + 2, n2 >> 8);
        CRunTime.memoryWriteByte(n + 1, n2 >> 16);
        CRunTime.memoryWriteByte(n + 0, n2 >> 24);
    }

    public static final void memoryWriteWordLeftPc(int n, int n2, int n3) {
        CRunTime.assertMemoryWrite("lwl", n, n2, n3);
        CRunTime.memoryWriteWordLeft(n2, n3);
    }

    public static final void kill() {
        CRunTime.memory[-1] = 0;
    }

    public static final long divu(int n, int n2) {
        long l;
        long l2;
        if (n < 0 || n2 < 0) {
            long l3 = n;
            long l4 = n2;
            l2 = (l3 &= 0xFFFFFFFFL) / (l4 &= 0xFFFFFFFFL);
            l = l3 % l4;
        } else {
            l2 = n / n2;
            l = n % n2;
        }
        return l << 32 | l2;
    }

    public static final long multu(int n, int n2) {
        long l = n;
        long l2 = n2;
        return (l &= 0xFFFFFFFFL) * (l2 &= 0xFFFFFFFFL);
    }

    public static final int sltu(int n, int n2) {
        long l = n;
        long l2 = n2;
        if ((l &= 0xFFFFFFFFL) < (l2 &= 0xFFFFFFFFL)) {
            return 1;
        }
        return 0;
    }

    public static final void emitFunctionEnterTrace(String string) {
        for (int i = 0; i < functionNesting; ++i) {
            string = " " + string;
        }
        ++functionNesting;
        CRunTime.emitTrace(string);
    }

    public static final void emitFunctionExitTrace(String string) {
        --functionNesting;
    }

    public static final void assertMemoryWrite(String string, int n, int n2, int n3) {
        if (n2 >= CRunTime.memoryReadWord(16) && n2 < CRunTime.memoryReadWord(20)) {
            System.out.println(string + " on 0x" + Integer.toHexString(n) + " memory[0x" + Integer.toHexString(n2) + "] = 0x" + Integer.toHexString(n3) + "");
        }
    }

    public static final void emitTrace(String string) {
        System.out.println(string);
    }

    public static final void emitRegisterTrace(int n, int n2, int n3) {
        System.out.println("  rs: 0x" + Integer.toHexString(n) + " rt: 0x" + Integer.toHexString(n2) + " rd: 0x" + Integer.toHexString(n3));
    }
}

