/*
 * Decompiled with CFR 0.152.
 */
package tinke.gemgame;

import com.nokia.mid.ui.FullCanvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import tinke.gemgame.GemGameMIDlet;
import tinke.gemgame.MainMenu;
import tinke.gemgame.Resources;
import tinke.gemgame.Score;
import tinke.gemgame.SetScore;

public class HighScore
extends FullCanvas
implements Runnable {
    private GemGameMIDlet parent = null;
    private MainMenu menu = null;
    private SetScore setScore = null;
    private final int[] colors = new int[]{0xFF0000, 0xFF8000, 0xFFFF00, 0x80FF00, 65280, 65408, 65535, 33023, 255, 0x8000FF, 0xFF00FF, 0xFF0080, 0xFF0000, 0xFF8000, 1048560, 0x80FF00};
    private int color = 0;
    private int offset = 0;
    private static final int[] sin = new int[]{0, 35, 70, 105, 139, 174, 208, 242, 276, 309, 342, 375, 407, 438, 469, 500, 530, 559, 588, 616, 643, 669, 695, 719, 743, 766, 788, 809, 829, 848, 866, 875, 891, 906, 921, 934, 951, 962, 972, 982, 990, 997, 1000, 997, 990, 982, 972, 962, 951, 934, 921, 906, 891, 875, 866, 848, 829, 809, 788, 766, 743, 719, 695, 669, 643, 616, 588, 559, 530, 500, 469, 438, 407, 375, 342, 309, 276, 242, 208, 174, 139, 105, 70, 35, 0, 35, 70, 105};
    protected Score score;
    private RecordStore highScores = null;
    private int[] scores;
    private String[] names;
    private int hiScore = 0;
    private final int WIDTH = this.getWidth();
    private final int HEIGHT = this.getHeight();
    private volatile Thread animationThread = null;

    public HighScore(GemGameMIDlet parent, MainMenu menu, SetScore setScore) {
        this.parent = parent;
        this.menu = menu;
        this.setScore = setScore;
        this.scores = new int[5];
        this.names = new String[5];
        for (int i = 1; i <= 5; ++i) {
            Score score = setScore.readRecord(i);
            this.names[i - 1] = score.playerName;
            this.scores[i - 1] = score.points;
        }
        this.hiScore = this.scores[0];
        this.start();
    }

    synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    synchronized void stop() {
        this.animationThread = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        try {
            while (currentThread == this.animationThread) {
                long startTime = System.currentTimeMillis();
                this.repaint(0, 0, this.WIDTH, this.HEIGHT);
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < (long)40) {
                    HighScore highScore = this;
                    synchronized (highScore) {
                        this.wait((long)40 - timeTaken);
                        continue;
                    }
                }
                Thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
        g.setFont(Font.getFont((int)32, (int)1, (int)16));
        g.setColor(255, 255, 255);
        g.drawString(Resources.getString(2), this.WIDTH / 2, 2, 17);
        for (int i = 0; i < 5; ++i) {
            g.setColor(this.colors[this.color + i]);
            g.setFont(Font.getFont((int)32, (int)1, (int)0));
            g.drawString(Integer.toString(this.scores[i]), 36 + 20 * sin[this.offset + i] / 1000, 27 + 20 * i, 24);
            g.setFont(Font.getFont((int)32, (int)1, (int)8));
            g.drawString(this.names[i], 42 + 20 * sin[this.offset + i] / 1000, 32 + 20 * i, 20);
        }
        ++this.color;
        if (this.color >= 12) {
            this.color -= 12;
        }
        ++this.offset;
        if (this.offset >= 83) {
            this.offset -= 83;
        }
    }

    public void keyPressed(int keyCode) {
        if (keyCode != -11) {
            this.parent.setDisplayable((Displayable)this.menu);
        }
    }

    public int getHighScore() {
        return this.hiScore;
    }
}

