/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import net.comcraft.src.Block;
import net.comcraft.src.BlockPositionHelper;
import net.comcraft.src.World;

public final class WorldUpdater {
    public static final int tickTime = 800;
    private World world;
    private Vector updatableBlocksList;
    private int outstandingTime;

    public WorldUpdater(World world) {
        this.world = world;
        this.updatableBlocksList = new Vector(512);
    }

    public void addBlockUpdatable(int x, int y, int z) {
        this.updatableBlocksList.addElement(new BlockPositionHelper(x, y, z));
    }

    public void removeBlockUpdatable(int x, int y, int z) {
        this.updatableBlocksList.removeElement(new BlockPositionHelper(x, y, z));
    }

    public void updateWorld(int dt) {
        int time = dt + this.outstandingTime;
        int counts = time / 800;
        int i = 0;
        while (i < counts) {
            time -= 800;
            int prevSize = this.updatableBlocksList.size();
            int n = 0;
            while (n < prevSize && n < this.updatableBlocksList.size()) {
                BlockPositionHelper blockPosition = (BlockPositionHelper)this.updatableBlocksList.elementAt(n);
                Block block = Block.blocksList[this.world.getBlockID(blockPosition.x, blockPosition.y, blockPosition.z)];
                if (block != null) {
                    block.tickBlock(this.world, blockPosition.x, blockPosition.y, blockPosition.z);
                }
                ++n;
            }
            ++i;
        }
        this.outstandingTime = time;
    }
}

