/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.comcraft.src.EntityPlayer;

public class WorldInfo {
    private float worldVersion = 5.0f;
    private float spawnX;
    private float spawnY;
    private float spawnZ;
    private int worldSize;
    private int worldTime;

    public int getWorldSize() {
        return this.worldSize;
    }

    public void setWorldInfo(EntityPlayer player, int worldSize) {
        this.spawnX = player.xPos;
        this.spawnY = player.yPos;
        this.spawnZ = player.zPos;
        this.worldSize = worldSize;
    }

    public void writeWorldInfo(DataOutputStream dataOutputStream, EntityPlayer player) throws IOException {
        dataOutputStream.writeFloat(this.worldVersion);
        dataOutputStream.writeInt(this.worldSize);
        dataOutputStream.writeFloat(this.spawnX);
        dataOutputStream.writeFloat(this.spawnY);
        dataOutputStream.writeFloat(this.spawnZ);
        dataOutputStream.writeInt(this.worldTime);
        player.writeToDataOutputStream(dataOutputStream);
    }

    public void loadWorldInfo(DataInputStream dataInputStream, EntityPlayer player) throws IOException {
        this.worldVersion = dataInputStream.readFloat();
        this.worldSize = dataInputStream.readInt();
        this.spawnX = dataInputStream.readFloat();
        this.spawnY = dataInputStream.readFloat();
        this.spawnZ = dataInputStream.readFloat();
        if (this.worldVersion >= 5.0f) {
            this.worldTime = dataInputStream.readInt();
        }
        player.loadFromDataInputStream(dataInputStream, this.worldVersion);
        if (this.worldVersion < 5.0f) {
            this.worldVersion = 5.0f;
        }
    }

    public void addWorldTime(int t) {
        this.worldTime += t;
    }

    public int getWorldTime() {
        return this.worldTime;
    }

    public void setWorldTime(int t) {
        this.worldTime = t;
    }
}

