/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.ServerGame;

public class ServerLoader {
    private final Comcraft cc;
    private Vector serverList;
    public ServerGame game = null;

    public ServerLoader(Comcraft cc) {
        this.cc = cc;
        this.serverList = new Vector();
    }

    private FileConnection open(int mode) throws IOException {
        return (FileConnection)Connector.open((String)this.cc.settings.getComcraftFileSystem().getPathToFolder("servers.info"), (int)mode);
    }

    public void updateServerList() {
        try {
            this.serverList.removeAllElements();
            if (!this.cc.settings.getComcraftFileSystem().isAvailable()) {
                return;
            }
            FileConnection file = this.open(3);
            if (!file.exists()) {
                file.create();
                this.update(file);
                return;
            }
            DataInputStream dis = file.openDataInputStream();
            int total = dis.readShort();
            int i = 0;
            while (i < total) {
                String name = dis.readUTF();
                String ip = dis.readUTF();
                this.serverList.addElement(new String[]{name, ip});
                ++i;
            }
            dis.close();
            file.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public Vector getServerList() {
        return this.serverList;
    }

    public void deleteServer(String[] selectedServer) {
        this.serverList.removeElement(selectedServer);
        this.update();
    }

    public void editServer(String[] existing, String name, String ip) {
        if (this.serverList.contains(existing)) {
            this.serverList.removeElement(existing);
        }
        this.addServer(name, ip);
    }

    public void addServer(String name, String ip) {
        this.serverList.insertElementAt(new String[]{name, ip}, 0);
        this.update();
    }

    private void update() {
        try {
            this.update(this.open(2));
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    private void update(FileConnection file) {
        try {
            DataOutputStream dos = file.openDataOutputStream();
            dos.writeShort(this.serverList.size());
            int i = 0;
            while (i < this.serverList.size()) {
                String[] serverinf = (String[])this.serverList.elementAt(i);
                dos.writeUTF(serverinf[0]);
                dos.writeUTF(serverinf[1]);
                ++i;
            }
            dos.close();
            file.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public void newGame(String ip) {
        ServerGame g = new ServerGame(this.cc, ip);
        if (g.hasConnected()) {
            this.game = g;
            this.game.begin();
        }
    }
}

