/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Vec3D;

public final class Plane {
    Vec3D normal = new Vec3D();
    Vec3D point = new Vec3D();
    float d;

    public Plane() {
    }

    public Plane(Vec3D v1, Vec3D v2, Vec3D v3) {
        this.set3Points(v1, v2, v3);
    }

    public void set3Points(Vec3D v1, Vec3D v2, Vec3D v3) {
        Vec3D aux1 = v1.subtractVector(v2);
        Vec3D aux2 = v3.subtractVector(v2);
        this.normal = aux2.crossProduct(aux1);
        this.normal.normalize();
        this.point.copy(v2);
        this.d = -this.normal.innerProduct(this.point);
    }

    public void setNormalAndPoint(Vec3D normal, Vec3D point) {
        this.normal.copy(normal);
        this.normal.normalize();
        this.d = -this.normal.innerProduct(point);
    }

    public void setCoefficients(float a, float b, float c, float d) {
        this.normal.setComponents(a, b, c);
        float l = this.normal.lengthVector();
        this.normal.setComponents(a / l, b / l, c / l);
        this.d = d / l;
    }

    public float distance(Vec3D p) {
        return this.d + this.normal.innerProduct(p);
    }
}

