/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.m3g.Transform;
import net.comcraft.client.Comcraft;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.InventoryPlayer;
import net.comcraft.src.MathHelper;
import net.comcraft.src.ModAPI;
import net.comcraft.src.RayObjectPosition;
import net.comcraft.src.ServerGame;
import net.comcraft.src.Touch;
import net.comcraft.src.Vec3D;

public class EntityPlayer
extends JsObject {
    private float maxSpeed = 3.0f;
    private Comcraft cc;
    private Vec3D vVec;
    public InventoryPlayer inventory;
    public float xPos;
    public float yPos;
    public float zPos;
    public float rotationYaw = 225.0f;
    public float rotationPitch = 340.0f;
    public boolean commandsAllowed = false;
    private float aspect;
    private float h;
    private float w;
    private AxisAlignedBB boundingBox;
    private ServerGame server = null;
    private Vec3D blockVec;
    private static final int ID_SET_PLAYER_ON_WORLD_CENTER = 100;
    private static final int ID_GET_BOUNDING_BOX = 101;
    private static final int ID_GET_PLAYER_TRANSFORM = 102;
    private static final int ID_GET_LOOK_FORW = 103;
    private static final int ID_GET_LOOK_RIGHT = 104;
    private static final int ID_GET_LOOK = 105;
    private static final int ID_GET_POSITION = 106;
    private static final int ID_ROTATE = 107;
    private static final int ID_MAX_SPEED = 108;
    private static final int ID_INVENTORY = 110;
    private static final int ID_X_POS = 112;
    private static final int ID_Y_POS = 114;
    private static final int ID_Z_POS = 116;
    private static final int ID_ROTATION_YAW = 118;
    private static final int ID_ROTATION_PITCH = 120;
    private static final int ID_COMMANDS_ALLOWED = 122;
    public static final JsObject PLAYER_PROTOTYPE = new JsObject(JsObject.OBJECT_PROTOTYPE).addNative("setPlayerOnWorldCenter", 100, 1).addNative("getBoundingBox", 101, 0).addNative("getPlayerTransform", 102, 0).addNative("getLookForw", 103, 0).addNative("getLookRight", 104, 0).addNative("getLook", 105, 2).addNative("getPosition", 106, 0).addNative("rotate", 107, 2).addNative("maxSpeed", 108, -1).addNative("inventory", 110, -1).addNative("xPos", 112, -1).addNative("yPos", 114, -1).addNative("zPos", 116, -1).addNative("rotationYaw", 118, -1).addNative("rotationPitch", 120, -1).addNative("commandsAllowed", 122, -1);

    public EntityPlayer(Comcraft cc) {
        super(PLAYER_PROTOTYPE);
        this.cc = cc;
        this.inventory = new InventoryPlayer();
        this.vVec = new Vec3D();
        this.xPos = 32.0f;
        this.yPos = 15.0f;
        this.zPos = 32.0f;
        this.aspect = (float)Comcraft.screenWidth / (float)Comcraft.screenHeight;
        this.h = 2.0f * (float)Math.tan(Math.toRadians(cc.settings.fov / 2.0f));
        this.w = this.aspect * this.h;
        this.boundingBox = new AxisAlignedBB(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.blockVec = new Vec3D(this.xPos, this.yPos, this.zPos);
        ModAPI.event.runEvent("Player.Construct", new Object[]{this});
    }

    public EntityPlayer(Comcraft cc, ServerGame server) {
        this(cc);
        this.server = server;
        this.inventory = new InventoryPlayer(server);
    }

    public void setPlayerOnWorldCenter(int worldSize) {
        this.xPos = worldSize * 4 / 2;
        this.yPos = 15.0f;
        this.zPos = worldSize * 4 / 2;
    }

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void moveEntity(int strafe, int up, int forw) {
        float dt = this.cc.dt;
        if (dt > 0.15f) {
            dt = 0.15f;
        }
        Vec3D movVec = new Vec3D(strafe, up, forw);
        ModAPI.event.runEvent("Game.Player.moveEntity", new Object[]{this, movVec});
        strafe = (int)movVec.x;
        up = (int)movVec.y;
        forw = (int)movVec.z;
        if (this.vVec.lengthVector() < this.maxSpeed) {
            Vec3D forward = this.getLookForw();
            Vec3D right = this.getLookRight();
            Vec3D newVec = new Vec3D();
            newVec.x += forward.x * (float)forw + right.x * (float)strafe;
            newVec.y += (float)up;
            newVec.z += forward.z * (float)forw + right.z * (float)strafe;
            newVec = newVec.normalize();
            newVec = newVec.crossProduct(10.5f * dt);
            this.vVec = this.vVec.addVector(newVec);
        }
    }

    public void onLivingUpdate(float dt) {
        this.updateEntityMove(dt);
    }

    private boolean collidesWithWorld(float xPosNew, float yPosNew, float zPosNew) {
        int xP = (int)xPosNew;
        int yP = (int)yPosNew;
        int zP = (int)zPosNew;
        int z = -1;
        while (z <= 1) {
            int y = -1;
            while (y <= 1) {
                int x = -1;
                while (x <= 1) {
                    AxisAlignedBB blockBoundingBox;
                    Block block = this.cc.world.getBlock(xP + x, yP + y, zP + z);
                    if (block != null && block.collidesWithPlayer() && (blockBoundingBox = this.cc.world.getBlockBoundingBox(xP + x, yP + y, zP + z)) != null && this.boundingBox.collidesWith(blockBoundingBox)) {
                        return true;
                    }
                    ++x;
                }
                ++y;
            }
            ++z;
        }
        return false;
    }

    private void updateEntityMove(float dt) {
        if (dt > 0.15f) {
            dt = 0.15f;
        }
        float xPosNew = this.xPos + this.vVec.x * dt;
        float yPosNew = this.yPos - this.vVec.y * dt;
        float zPosNew = this.zPos + this.vVec.z * dt;
        this.boundingBox.setBounds(xPosNew - 0.2f, yPosNew - 0.2f, zPosNew - 0.2f, xPosNew + 0.2f, yPosNew + 0.2f, zPosNew + 0.2f);
        if (!this.collidesWithWorld(xPosNew, yPosNew, zPosNew)) {
            Vec3D newVec;
            if (this.server != null && this.blockVec.distanceTo(newVec = new Vec3D(xPosNew, yPosNew, zPosNew)) >= 1.0f) {
                this.server.playerMoved(this);
                this.blockVec = newVec;
            }
            this.xPos = xPosNew;
            this.yPos = yPosNew;
            this.zPos = zPosNew;
        } else {
            this.vVec.setComponents(0.0f, 0.0f, 0.0f);
        }
        Vec3D slowVec = new Vec3D(this.vVec);
        slowVec = slowVec.normalize();
        slowVec = slowVec.crossProduct(9.0f * dt);
        Vec3D prevVec = new Vec3D(this.vVec);
        ModAPI.event.runEvent("Game.Player.updateEntityMove", new Object[]{this, slowVec, this.vVec});
        this.vVec = slowVec.subtractVector(this.vVec);
        if (MathHelper.isOpositeSign(this.vVec.x, prevVec.x)) {
            this.vVec.setComponents(0.0f, 0.0f, 0.0f);
        } else if (MathHelper.isOpositeSign(this.vVec.y, prevVec.y)) {
            this.vVec.setComponents(0.0f, 0.0f, 0.0f);
        } else if (MathHelper.isOpositeSign(this.vVec.z, prevVec.z)) {
            this.vVec.setComponents(0.0f, 0.0f, 0.0f);
        }
    }

    public Transform getPlayerTransform() {
        Transform transform = new Transform();
        transform.postTranslate(this.xPos * 10.0f, this.yPos * 10.0f, this.zPos * 10.0f);
        transform.postRotate(this.rotationYaw, 0.0f, 1.0f, 0.0f);
        transform.postRotate(this.rotationPitch, 1.0f, 0.0f, 0.0f);
        if (Touch.isTouchSupported()) {
            transform.postRotate(90.0f, 0.0f, 0.0f, 1.0f);
        }
        return transform;
    }

    public Vec3D getLookForw() {
        Vec3D vec3D = this.getLook();
        vec3D.y = 0.0f;
        return vec3D.normalize();
    }

    public Vec3D getLookRight() {
        return this.getLook().crossProduct(new Vec3D(0.0f, 1.0f, 0.0f)).normalize();
    }

    public Vec3D getLook() {
        float cosX = (float)Math.cos(Math.toRadians(this.rotationPitch));
        float lookX = (float)Math.sin(Math.toRadians(this.rotationYaw)) * cosX;
        float lookY = (float)Math.sin(Math.toRadians(this.rotationPitch));
        float lookZ = (float)Math.cos(Math.toRadians(this.rotationYaw)) * cosX;
        return new Vec3D(lookX, lookY, lookZ).normalize();
    }

    public Vec3D getLook(int x, int y) {
        Vec3D dir1 = this.getLook();
        dir1.normalize();
        Vec3D dir1c = new Vec3D(dir1);
        Vec3D right_dir = this.getLookRight();
        Vec3D up_dir = dir1c.crossProduct(right_dir);
        up_dir.normalize();
        Vec3D center = new Vec3D(((float)y / (float)Comcraft.screenHeight - 0.5f) * this.h, (0.5f - (float)x / (float)Comcraft.screenWidth) * this.w, 0.0f);
        Vec3D centerWS = right_dir.crossProduct(center.x).addVector(up_dir.crossProduct(center.y));
        Vec3D dir2 = dir1.addVector(centerWS);
        dir2.normalize();
        return dir2;
    }

    public Vec3D getPosition() {
        return new Vec3D(this.xPos, this.yPos, this.zPos);
    }

    public void rotate(float rotationPitch, float rotationYaw) {
        this.rotationYaw -= rotationYaw;
        this.rotationPitch += rotationPitch;
        if (rotationPitch > 85.0f && rotationPitch < 180.0f) {
            this.rotationPitch = 85.0f;
        }
        if (this.rotationPitch > 445.0f) {
            this.rotationPitch = 445.0f;
        }
        if (this.rotationPitch < 275.0f && this.rotationPitch > 180.0f) {
            this.rotationPitch = 275.0f;
        }
        if (this.rotationYaw > 360.0f) {
            this.rotationYaw %= 360.0f;
        } else if (this.rotationYaw < 0.0f) {
            this.rotationYaw = 360.0f + this.rotationYaw;
        }
    }

    public RayObjectPosition rayTrace(float reachDistance) {
        return this.cc.world.rayTraceBlocks(this.getPosition(), this.getLook(), reachDistance);
    }

    public RayObjectPosition rayTrace(float reachDistance, int x, int y) {
        return this.cc.world.rayTraceBlocks(this.getPosition(), this.getLook(x, y), reachDistance);
    }

    public void loadFromDataInputStream(DataInputStream dataInputStream, float worldVersion) throws IOException {
        this.xPos = dataInputStream.readFloat();
        this.yPos = dataInputStream.readFloat();
        this.zPos = dataInputStream.readFloat();
        this.rotationPitch = dataInputStream.readFloat();
        this.rotationYaw = dataInputStream.readFloat();
        int fastSlotSize = dataInputStream.readInt();
        int n = 0;
        while (n < fastSlotSize) {
            int id = dataInputStream.readInt();
            int stackSize = 1;
            if (worldVersion >= 5.0f) {
                stackSize = dataInputStream.read();
            }
            this.inventory.setItemStackAt(n, new InvItemStack(id, stackSize));
            ++n;
        }
        if (worldVersion == 3.0f) {
            return;
        }
        this.commandsAllowed = dataInputStream.readBoolean();
    }

    public void writeToDataOutputStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.xPos);
        dataOutputStream.writeFloat(this.yPos);
        dataOutputStream.writeFloat(this.zPos);
        dataOutputStream.writeFloat(this.rotationPitch);
        dataOutputStream.writeFloat(this.rotationYaw);
        dataOutputStream.writeInt(this.inventory.getFastSlotSize());
        int n = 0;
        while (n < this.inventory.getFastSlotSize()) {
            InvItemStack stack = this.inventory.getItemStackAt(n);
            dataOutputStream.writeInt(stack != null ? stack.itemID : 0);
            dataOutputStream.write(stack != null ? stack.stackSize : 0);
            ++n;
        }
        dataOutputStream.writeBoolean(this.commandsAllowed);
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 100: {
                this.setPlayerOnWorldCenter(stack.getInt(sp + 2));
                break;
            }
            case 101: {
                stack.setObject(sp, (Object)this.getBoundingBox());
                break;
            }
            case 102: {
                stack.setObject(sp, (Object)this.getPlayerTransform());
                break;
            }
            case 103: {
                stack.setObject(sp, (Object)this.getLookForw());
                break;
            }
            case 104: {
                stack.setObject(sp, (Object)this.getLookRight());
                break;
            }
            case 105: {
                if (parCount < 2) {
                    stack.setObject(sp, (Object)this.getLook());
                    break;
                }
                stack.setObject(sp, (Object)this.getLook(stack.getInt(sp + 2), stack.getInt(sp + 3)));
                break;
            }
            case 106: {
                stack.setObject(sp, (Object)this.getPosition());
                break;
            }
            case 107: {
                this.rotate((float)stack.getNumber(sp + 2), (float)stack.getNumber(sp + 3));
                break;
            }
            case 108: {
                stack.setNumber(sp, (double)this.maxSpeed);
                break;
            }
            case 109: {
                this.maxSpeed = (float)stack.getNumber(sp);
                break;
            }
            case 110: {
                stack.setObject(sp, (Object)this.inventory);
                break;
            }
            case 112: {
                stack.setNumber(sp, (double)this.xPos);
                break;
            }
            case 114: {
                stack.setNumber(sp, (double)this.yPos);
                break;
            }
            case 116: {
                stack.setNumber(sp, (double)this.zPos);
                break;
            }
            case 118: {
                stack.setNumber(sp, (double)this.rotationYaw);
                break;
            }
            case 120: {
                stack.setNumber(sp, (double)this.rotationPitch);
                break;
            }
            case 122: {
                stack.setBoolean(sp, this.commandsAllowed);
                break;
            }
            case 113: 
            case 115: 
            case 117: 
            case 119: 
            case 121: 
            case 123: {
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

