/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Sprite3D;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Effect;

public class EffectExplosion
extends Effect {
    private static Appearance appearance;
    private static Sprite3D[] explosionSprites3D;
    private Random rand = new Random();

    static {
        explosionSprites3D = new Sprite3D[16];
    }

    public EffectExplosion(Comcraft cc, String path, float x, float y, float z) {
        super(cc, x, y, z);
        this.aliveTime = this.fullTime = (int)(this.rand.nextFloat() * 500.0f + 500.0f);
        if (appearance == null) {
            this.initEffect(path);
        }
    }

    private void initEffect(String path) {
        appearance = new Appearance();
        Image image = this.cc.textureProvider.getImage(path);
        int width = image.getWidth() / 4;
        int height = image.getHeight() / 4;
        int yI = 0;
        while (yI < 4) {
            int xI = 0;
            while (xI < 4) {
                int trans = this.rand.nextInt(5);
                trans = trans == 0 ? 0 : (trans == 1 ? 3 : (trans == 2 ? 5 : (trans == 3 ? 6 : 2)));
                Image frame = Image.createImage((Image)image, (int)(xI * width), (int)(yI * height), (int)width, (int)height, (int)trans);
                Image2D image2D = new Image2D(100, (Object)frame);
                EffectExplosion.explosionSprites3D[yI * 4 + xI] = new Sprite3D(true, image2D, appearance);
                ++xI;
            }
            ++yI;
        }
    }

    public void renderEffect() {
        int frame = 15 - (int)((float)this.aliveTime / (float)this.fullTime * 16.0f);
        if (frame > 15) {
            frame = 15;
        }
        this.g3d.render((Node)explosionSprites3D[frame], this.getTransform());
    }

    public boolean isAlive() {
        return this.aliveTime > 0;
    }

    public void tickEffect(int tickTime) {
        this.aliveTime -= tickTime;
    }
}

