/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;

public class ChunkStorage {
    private byte[] blockIDArray = new byte[64];
    private byte[] blockMetadataArray = new byte[64];
    public boolean containsBlocks;
    public boolean containsNonOpaqueBlocks;

    public int getBlockID(int x, int y, int z) {
        return this.blockIDArray[x + (y << 2) + (z << 4)] & 0xFF;
    }

    public void setBlockID(int x, int y, int z, int id) {
        if (id != 0) {
            this.containsBlocks = true;
            if (!Block.blocksList[id].isNormal()) {
                this.containsNonOpaqueBlocks = true;
            }
        }
        this.blockIDArray[x + (y << 2) + (z << 4)] = (byte)id;
    }

    public int getBlockMetadata(int x, int y, int z) {
        return this.blockMetadataArray[x + (y << 2) + (z << 4)];
    }

    public void setBlockMetadata(int x, int y, int z, int metadata) {
        this.blockMetadataArray[x + (y << 2) + (z << 4)] = (byte)metadata;
    }

    public byte[] getBlockIDArray() {
        return this.blockIDArray;
    }

    public void setBlockIDArray(byte[] data) {
        this.blockIDArray = data;
    }

    public byte[] getBlockMetadataArray() {
        return this.blockMetadataArray;
    }

    public void setBlockMetadataArray(byte[] data) {
        this.blockMetadataArray = data;
    }

    public void initBlockStorage() {
        this.containsBlocks = false;
        this.containsNonOpaqueBlocks = false;
        int i = 0;
        while (i < 64) {
            if (this.blockIDArray[i] != 0) {
                this.containsBlocks = true;
                if (!Block.blocksList[this.blockIDArray[i] & 0xFF].isNormal()) {
                    this.containsNonOpaqueBlocks = true;
                    return;
                }
            }
            ++i;
        }
    }
}

