/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import net.comcraft.src.Block;
import net.comcraft.src.EffectExplosion;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItem;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.World;

public class BlockTNT
extends Block {
    private int indexSides;
    private int indexTop;
    private int indexBottom;
    private int indexSidesExp;
    private int indexTopExp;
    private int indexBottomExp;
    private int boomRadius;
    private int boomTime;
    private Random rand = new Random();

    public BlockTNT(int id, int indexSides, int indexTop, int indexBottom, int indexSidesExp, int indexTopExp, int indexBottomExp, int boomRange, int boomTime) {
        super(id);
        this.indexSides = indexSides;
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
        this.indexSidesExp = indexSidesExp;
        this.indexTopExp = indexTopExp;
        this.indexBottomExp = indexBottomExp;
        this.boomRadius = boomRange;
        this.boomTime = boomTime;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexSides, this.indexTop, this.indexBottom, this.indexSidesExp, this.indexTopExp, this.indexBottomExp};
    }

    public int getRenderType() {
        return 0;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    private void addBoomEfects(World world, int x, int y, int z) {
        int particles = this.rand.nextInt(3 * this.boomRadius) + 10 * this.boomRadius;
        int n = 0;
        while (n < particles) {
            float xD = this.rand.nextFloat() * (float)(this.boomRadius * 2 + 1) - (float)(this.boomRadius * 2 + 1) / 2.0f + (float)x;
            float yD = this.rand.nextFloat() * (float)(this.boomRadius * 2 - 1) - (float)(this.boomRadius * 2 - 1) / 2.0f + (float)y;
            float zD = this.rand.nextFloat() * (float)(this.boomRadius * 2 + 1) - (float)(this.boomRadius * 2 + 1) / 2.0f + (float)z;
            world.cc.render.renderEffects.addEffect(new EffectExplosion(world.cc, "misc/explosion.png", xD * 10.0f, yD * 10.0f, zD * 10.0f));
            ++n;
        }
    }

    private void tntBooom(World world, int x, int y, int z) {
        int xI;
        int yI;
        world.cc.vibrate(200);
        world.setBlockID(x, y, z, 0);
        boolean waterFound = false;
        int zI = -1;
        while (zI <= 1) {
            yI = -1;
            while (yI <= 1) {
                xI = -1;
                while (xI <= 1) {
                    if (world.getBlockID(x + xI, y + yI, z + zI) == Block.getBlock((String)"water").blockID) {
                        waterFound = true;
                    }
                    ++xI;
                }
                ++yI;
            }
            ++zI;
        }
        if (!waterFound) {
            zI = -this.boomRadius;
            while (zI <= this.boomRadius) {
                yI = -this.boomRadius;
                while (yI <= this.boomRadius) {
                    xI = -this.boomRadius;
                    while (xI <= this.boomRadius) {
                        if (zI * zI + yI * yI * xI * xI <= this.boomRadius * this.boomRadius) {
                            int id = world.getBlockID(x + xI, y + yI, z + zI);
                            if (id == Block.getBlock((String)"tnt").blockID || world.getBlockID(x + xI, y + yI, z + zI) == Block.getBlock((String)"tntWeak").blockID || world.getBlockID(x + xI, y + yI, z + zI) == Block.getBlock((String)"tntStrong").blockID) {
                                Block.blocksList[this.blockID].blockActivated(world, x + xI, y + yI, z + zI, null, null);
                            } else if (id != 0) {
                                world.setBlockID(x + xI, y + yI, z + zI, 0);
                            }
                        }
                        ++xI;
                    }
                    ++yI;
                }
                ++zI;
            }
        }
        this.addBoomEfects(world, x, y, z);
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        if (itemStack != null && itemStack.itemID != InvItem.detonator.shiftedIndex) {
            return false;
        }
        int time = 1;
        if (entityplayer == null) {
            time = this.boomTime;
        }
        world.setBlockMetadata(x, y, z, time);
        world.getWorldUpdater().addBlockUpdatable(x, y, z);
        return true;
    }

    public void tickBlock(World world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        if (metadata >= this.boomTime) {
            this.tntBooom(world, x, y, z);
            world.getWorldUpdater().removeBlockUpdatable(x, y, z);
        } else {
            world.setBlockMetadata(x, y, z, metadata + 1);
        }
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world != null && world.getBlockMetadata(x, y, z) > 0) {
            if (side == 4) {
                return this.indexTopExp;
            }
            if (side == 5) {
                return this.indexBottomExp;
            }
            return this.indexSidesExp;
        }
        if (side == 4) {
            return this.indexTop;
        }
        if (side == 5) {
            return this.indexBottom;
        }
        return this.indexSides;
    }
}

