/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.ModelPieceSlab;
import net.comcraft.src.ModelStairs;
import net.comcraft.src.World;

public class BlockStairs
extends Block {
    public BlockStairs(int id, int index) {
        super(id, index);
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        if (side == 5 || side == 10) {
            return !world.isBlockNormal(x, y, z);
        }
        return true;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean canBePieced() {
        return false;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        return ModelStairs.vertexBuffer;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelPieceSlab.indexBuffer;
    }

    public boolean isNormal() {
        return false;
    }

    public int getRenderType() {
        return 7;
    }

    public Transform getBlockTransform(World world, int x, int y, int z, Transform transform, int s) {
        if (world == null) {
            return transform;
        }
        Transform blockTransform = new Transform();
        blockTransform.set(transform);
        int side = world.getBlockMetadata(x, y, z);
        if (side == 3) {
            blockTransform.postRotate(270.0f, 0.0f, 1.0f, 0.0f);
            blockTransform.postTranslate(0.0f, 0.0f, -10.0f);
        } else if (side == 0) {
            blockTransform.postRotate(180.0f, 0.0f, 1.0f, 0.0f);
            blockTransform.postTranslate(-10.0f, 0.0f, -10.0f);
        } else if (side == 1) {
            blockTransform.postRotate(0.0f, 0.0f, 1.0f, 0.0f);
        } else if (side == 2) {
            blockTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
            blockTransform.postTranslate(-10.0f, 0.0f, 0.0f);
        }
        return blockTransform;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata = entityPlayer.rotationYaw >= 45.0f && entityPlayer.rotationYaw <= 135.0f ? 3 : (entityPlayer.rotationYaw >= 135.0f && entityPlayer.rotationYaw <= 225.0f ? 1 : (entityPlayer.rotationYaw >= 225.0f && entityPlayer.rotationYaw <= 315.0f ? 2 : 0));
        world.setBlockMetadata(x, y, z, metadata);
    }
}

