/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Random;
import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.World;

public class BlockEmoticon
extends Block {
    private int indexFront;
    private int indexSide;
    private int indexTop;
    private int indexBottom;
    protected int[] indexActivated;
    private Random random;

    public BlockEmoticon(int id, int indexFront, int indexSide, int indexTop, int indexBottom, int[] indexActivated) {
        super(id);
        this.indexFront = indexFront;
        this.indexSide = indexSide;
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
        this.indexActivated = indexActivated;
        this.random = new Random();
    }

    public int[] getUsedTexturesList() {
        int[] tex = new int[]{this.indexFront, this.indexSide, this.indexTop, this.indexBottom};
        int[] list = new int[tex.length + this.indexActivated.length];
        int n = 0;
        while (n < list.length) {
            list[n] = n < tex.length ? tex[n] : this.indexActivated[n - tex.length];
            ++n;
        }
        return list;
    }

    protected int getActivatedTextureIndex(World world, int x, int y, int z) {
        if (world == null) {
            return 0;
        }
        return world.getBlockMetadata(x, y, z) >> 3;
    }

    private int getSide(World world, int x, int y, int z) {
        if (world == null) {
            return 0;
        }
        return world.getBlockMetadata(x, y, z) & 3;
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        int index = this.getNextTextureIndex(world, x, y, z);
        world.setBlockMetadata(x, y, z, this.getMetadataToSave(this.getSide(world, x, y, z), true, index));
        return true;
    }

    protected int getNextTextureIndex(World world, int x, int y, int z) {
        int nextIndex;
        while ((nextIndex = this.random.nextInt(this.indexActivated.length)) == this.getActivatedTextureIndex(world, x, y, z)) {
        }
        return nextIndex;
    }

    public boolean canBePieced() {
        return false;
    }

    public int getRenderType() {
        return 0;
    }

    private boolean isActivated(World world, int x, int y, int z) {
        if (world == null) {
            return false;
        }
        return (world.getBlockMetadata(x, y, z) >> 2 & 1) == 1;
    }

    private int getMetadataToSave(int side, boolean activated, int index) {
        int metadata = 0;
        int act = activated ? 1 : 0;
        metadata |= side;
        metadata |= act << 2;
        return metadata |= index << 3;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (side == this.getSide(world, x, y, z)) {
            if (this.isActivated(world, x, y, z)) {
                return this.indexActivated[this.getActivatedTextureIndex(world, x, y, z)];
            }
            return this.indexFront;
        }
        if (side == 4) {
            return this.indexTop;
        }
        if (side == 5) {
            return this.indexBottom;
        }
        return this.indexSide;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        int side = entityPlayer.rotationYaw >= 45.0f && entityPlayer.rotationYaw <= 135.0f ? 3 : (entityPlayer.rotationYaw >= 135.0f && entityPlayer.rotationYaw <= 225.0f ? 1 : (entityPlayer.rotationYaw >= 225.0f && entityPlayer.rotationYaw <= 315.0f ? 2 : 0));
        world.setBlockMetadata(x, y, z, this.getMetadataToSave(side, this.isActivatedByDefault(), 0));
    }

    protected boolean isActivatedByDefault() {
        return false;
    }
}

