/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.Block;
import net.comcraft.src.ModelChristmasTree;
import net.comcraft.src.World;

public class BlockChristmasTree
extends Block {
    private int indexTop;
    private int indexBottom;

    public BlockChristmasTree(int id, int indexTop, int indexBottom) {
        super(id);
        this.indexTop = indexTop;
        this.indexBottom = indexBottom;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        return true;
    }

    public boolean isNormal() {
        return false;
    }

    public int[] getUsedTexturesList() {
        return new int[]{this.indexTop, this.indexBottom};
    }

    private int getChristrmasTreeSide(World world, int x, int y, int z) {
        if (world == null) {
            return 0;
        }
        return world.getBlockMetadata(x, y, z);
    }

    public void onBlockPlaced(World world, int x, int y, int z, int side) {
        if (super.canPlaceBlockAt(world, x, y - 1, z)) {
            world.setBlockMetadata(x, y, z, 1);
            world.setBlockAndMetadata(x, y - 1, z, this.blockID, 0);
        } else if (super.canPlaceBlockAt(world, x, y + 1, z)) {
            world.setBlockMetadata(x, y, z, 0);
            world.setBlockAndMetadata(x, y + 1, z, this.blockID, 1);
        }
    }

    public VertexBuffer[][][][] getBlockVertexBuffer(World world, int x, int y, int z) {
        return ModelChristmasTree.vertexBuffer[this.getChristrmasTreeSide(world, x, y, z)];
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelChristmasTree.indexBuffer;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        if (world == null) {
            return this.indexTop;
        }
        if (this.getChristrmasTreeSide(world, x, y, z) == 0) {
            return this.indexBottom;
        }
        return this.indexTop;
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
        int side = this.getChristrmasTreeSide(world, x, y, z);
        if (side == 0) {
            world.setBlockID(x, y + 1, z, 0);
        } else if (side == 1) {
            world.setBlockID(x, y - 1, z, 0);
        }
    }

    public int getRenderType() {
        return 0;
    }
}

