/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsException;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsObject;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.BlockAlphabet;
import net.comcraft.src.BlockAnimal;
import net.comcraft.src.BlockBed;
import net.comcraft.src.BlockCraftingTable;
import net.comcraft.src.BlockDirt;
import net.comcraft.src.BlockDoor;
import net.comcraft.src.BlockEmoticon;
import net.comcraft.src.BlockFence;
import net.comcraft.src.BlockFlower;
import net.comcraft.src.BlockFurnance;
import net.comcraft.src.BlockGlass;
import net.comcraft.src.BlockGrass;
import net.comcraft.src.BlockIce;
import net.comcraft.src.BlockLiquid;
import net.comcraft.src.BlockPlayer;
import net.comcraft.src.BlockSidesTop;
import net.comcraft.src.BlockSidesTopBottom;
import net.comcraft.src.BlockSlab;
import net.comcraft.src.BlockStairs;
import net.comcraft.src.BlockTNT;
import net.comcraft.src.BlockTitle;
import net.comcraft.src.BlockTorch;
import net.comcraft.src.BlockTreePlant;
import net.comcraft.src.BlockWheat;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.EventHandler;
import net.comcraft.src.InvItem;
import net.comcraft.src.InvItemBlock;
import net.comcraft.src.InvItemSlab;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.ModArray;
import net.comcraft.src.ModelPieceBlock;
import net.comcraft.src.World;

public class Block
extends JsObject {
    public static final Block[] blocksList = new Block[256];
    public int blockID;
    private String blockName;
    private String blockPlacingSound = "/sound/block_placed.wav";
    private String blockDestroyingSound = "/sound/block_placed.wav";
    private boolean collidesWithPlayer = true;
    private boolean doesBlockDestroyGrass = true;
    private boolean isReplaceableBlock = false;
    private boolean isUpdatableBlock = false;
    private boolean canBePieced = true;
    private boolean canBePiecedVertically = true;
    private boolean isNormal = true;
    private int RenderType = 1;
    private int IdDropped;
    private EventHandler eh = new EventHandler(new String[]{"getBlockTransform", "getBlockTexture", "shouldSideBeRendered", "getCollisionBoundingBoxFromPool", "canPlaceBlockAt", "canPlaceBlockOnSide", "blockActivated", "onBlockPlaced", "onBlockPlacedBy", "onBlockDestroyedByPlayer", "onNeighborBlockChange", "onBlockRemoval", "onBlockAdded", "tickBlock", "getBlockModel"});
    private VertexBuffer[][][][] BlockVertexBufferPieced = ModelPieceBlock.vertexBuffer;
    private IndexBuffer BlockIndexBuffer = ModelPieceBlock.indexBuffer;
    private int[] UsedTexturesList;
    private VertexBuffer[] BlockVertexBufferSided = null;
    public static final int ID_CONSTRUCT = 100;
    private static final int ID_GET_BLOCK_NAME = 101;
    private static final int ID_COLLIDES_WITH_PLAYER = 102;
    private static final int ID_DOES_BLOCK_DESTROY_GRASS = 104;
    private static final int ID_IS_REPLACEABLE_BLOCK = 106;
    private static final int ID_IS_UPDATABLE_BLOCK = 108;
    private static final int ID_CAN_BE_PIECED = 110;
    private static final int ID_CAN_BE_PIECED_VERTICALLY = 112;
    private static final int ID_IS_NORMAL = 114;
    private static final int ID_RENDER_TYPE = 116;
    private static final int ID_ID_DROPPED = 118;
    private static final int ID_BLOCK_PLACING_SOUND = 120;
    private static final int ID_BLOCK_DESTROYING_SOUND = 122;
    private static final int ID_BLOCK_VERTEX_BUFFER_PIECED = 124;
    private static final int ID_BLOCK_VERTEX_BUFFER_SIDED = 126;
    private static final int ID_BLOCK_INDEX_BUFFER = 128;
    private static final int ID_GET_BLOCK_TRANSFORM = 130;
    private static final int ID_GET_BLOCK_TEXTURE = 132;
    private static final int ID_SHOULD_SIDE_BE_RENDERED = 134;
    private static final int ID_GET_COLLISION_BOUNDING_BOX_FROM_POOL = 136;
    private static final int ID_CAN_PLACE_BLOCK_AT = 138;
    private static final int ID_CAN_PLACE_BLOCK_ON_SIDE = 140;
    private static final int ID_BLOCK_ACTIVATED = 142;
    private static final int ID_ON_BLOCK_PLACED = 144;
    private static final int ID_ON_BLOCK_PLACED_BY = 146;
    private static final int ID_ON_BLOCK_DESTROYED_BY_PLAYER = 148;
    private static final int ID_ON_NEIGHBOR_BLOCK_CHANGE = 150;
    private static final int ID_ON_BLOCK_REMOVAL = 152;
    private static final int ID_ON_BLOCK_ADDED = 154;
    private static final int ID_TICK_BLOCK = 156;
    private static final int ID_GET_BLOCK_MODEL = 158;
    private static final int ID_GET_BLOCK = 160;
    public static final JsObject BLOCK_PROTOTYPE = new Block(JsObject.OBJECT_PROTOTYPE).addNative("getBlockName", 101, 0).addNative("collidesWithPlayer", 102, -1).addNative("doesBlockDestroyGrass", 104, -1).addNative("isReplaceableBlock", 106, -1).addNative("isUpdatableBlock", 108, -1).addNative("canBePieced", 110, -1).addNative("canBePiecedVertically", 112, -1).addNative("isNormal", 114, -1).addNative("RenderType", 116, -1).addNative("IdDropped", 118, -1).addNative("blockPlacingSound", 120, -1).addNative("blockDestroyingSound", 122, -1).addNative("blockVertexBufferPieced", 124, -1).addNative("blockVertexBufferSided", 126, -1).addNative("blockIndexBuffer", 128, -1).addNative("getBlockTransform", 130, -1).addNative("getBlockTexture", 132, -1).addNative("shouldSideBeRendered", 134, -1).addNative("getCollisionBoundingBoxFromPool", 136, -1).addNative("canPlaceBlockAt", 138, -1).addNative("canPlaceBlockOnSide", 140, -1).addNative("blockActivated", 142, -1).addNative("onBlockPlaced", 144, -1).addNative("onBlockPlacedBy", 146, -1).addNative("onBlockDestroyedByPlayer", 148, -1).addNative("onNeighborBlockChange", 150, -1).addNative("onBlockRemoval", 152, -1).addNative("onBlockAdded", 154, -1).addNative("tickBlock", 156, -1).addNative("getBlockModel", 158, -1).addNative("getBlock", 160, 2);

    static {
        new Block(1, 1).setBlockName("stone");
        new BlockGrass(2, 3, 0, 2).setBlockName("grass");
        new BlockDirt(3, 2).setBlockName("dirt");
        new BlockGlass(4, 49).setBlockName("glass");
        new Block(5, 53).setBlockName("leaves");
        new Block(6, 18).setBlockName("sand");
        new Block(7, 4).setBlockName("planks");
        new BlockSidesTopBottom(8, 20, 21, 21).setBlockName("wood");
        new Block(9, 7).setBlockName("brick");
        new Block(10, 64).setBlockName("woolWhite");
        new Block(11, 113).setBlockName("woolBlack");
        new Block(12, 129).setBlockName("woolRed");
        new Block(13, 177).setBlockName("woolBlue");
        new Block(14, 162).setBlockName("woolYellow");
        new Block(15, 145).setBlockName("woolGreen");
        new Block(16, 16).setBlockName("cobblestone");
        new Block(17, 37).setBlockName("obsidian");
        new BlockSidesTop(18, 35, 4).setBlockName("bookshelve");
        new BlockFurnance(19, 119, 118, 102, 102, 120).setBlockName("pumpkin");
        new BlockIce(20, 67).setBlockName("ice");
        new Block(21, 54).setBlockName("stoneBrick");
        new Block(22, 36).setBlockName("mossStone");
        new Block(23, 22).setBlockName("iron");
        new Block(24, 23).setBlockName("gold");
        new Block(25, 24).setBlockName("diamond");
        new Block(26, 17).setBlockName("bedrock");
        new BlockSlab(27, 5, 6).setBlockName("stoneSlab");
        new BlockSlab(28, 4, 4).setBlockName("plankSlab");
        new BlockSidesTop(29, 5, 6).setBlockName("doubleStoneSlab");
        new BlockSlab(30, 16, 16).setBlockName("cobblestoneSlab");
        new BlockSidesTop(31, 70, 69).setBlockName("cactus");
        new Block(32, 225).setBlockName("woolLightGray");
        new Block(33, 114).setBlockName("woolGray");
        new Block(34, 210).setBlockName("woolOrange");
        new Block(35, 146).setBlockName("woolLime");
        new Block(36, 209).setBlockName("woolCyan");
        new Block(37, 178).setBlockName("woolLightBlue");
        new Block(38, 193).setBlockName("woolPurple");
        new Block(39, 194).setBlockName("woolMagenta");
        new Block(40, 130).setBlockName("woolPink");
        new Block(41, 161).setBlockName("woolBrown");
        new BlockLiquid(42, 205).setBlockName("water");
        new BlockFlower(43, 12).setBlockName("redFlower");
        new BlockFlower(44, 13).setBlockName("yellowFlower");
        new BlockTreePlant(45, 15).setBlockName("treePlant");
        new BlockFlower(46, 28).setBlockName("toadstool");
        new BlockFlower(47, 29).setBlockName("mushroom");
        new BlockLiquid(48, 237).setBlockName("lava");
        new BlockSidesTopBottom(49, 68, 66, 2).setBlockName("snow");
        new Block(50, 66).setBlockName("snowBlock");
        new Block(51, 192).setBlockName("sandStone");
        new Block(52, 144).setBlockName("lapisLazuli");
        new BlockCraftingTable(53, 59, 60, 43, 43).setBlockName("craftingTable");
        new BlockFurnance(54, 44, 45, 62, 62, 61).setBlockName("furnace");
        new BlockTNT(55, 8, 9, 10, 256, 257, 258, 3, 3).setBlockName("tnt");
        new Block(56, 103).setBlockName("netherrack");
        new Block(57, 224).setBlockName("netherBrick");
        new Block(58, 104).setBlockName("soulSand");
        new BlockTitle(60, 4).setBlockName("plankTitle");
        new Block(61, 198).setBlockName("planks1");
        new Block(62, 199).setBlockName("planks2");
        new Block(63, 214).setBlockName("planks3");
        new BlockSlab(64, 198, 198).setBlockName("plankSlab1");
        new BlockSlab(65, 199, 199).setBlockName("plankSlab2");
        new BlockSlab(66, 214, 214).setBlockName("plankSlab3");
        new BlockSlab(67, 224, 224).setBlockName("netherBrickSlab");
        new BlockSlab(68, 7, 7).setBlockName("brickSlab");
        new BlockSidesTopBottom(69, 116, 21, 21).setBlockName("wood1");
        new BlockSidesTopBottom(70, 117, 21, 21).setBlockName("wood2");
        new BlockTitle(72, 198).setBlockName("plankTitle1");
        new BlockTitle(73, 199).setBlockName("plankTitle2");
        new BlockTitle(74, 214).setBlockName("plankTitle3");
        new BlockTitle(75, 7).setBlockName("brickTitle");
        new BlockTitle(76, 224).setBlockName("netherBrickTitle");
        new BlockTitle(77, 6).setBlockName("stoneTitle");
        new BlockTorch(78, 80).setBlockName("torch");
        new BlockDoor(79, 81, 97).setBlockName("woodenDoor");
        new BlockDoor(80, 82, 98).setBlockName("ironDoor");
        new BlockTitle(81, 16).setBlockName("cobblestoneTitle");
        new BlockStairs(82, 4).setBlockName("plankStairs");
        new BlockStairs(83, 198).setBlockName("plankStairs1");
        new BlockStairs(84, 199).setBlockName("plankStairs2");
        new BlockStairs(85, 214).setBlockName("plankStairs3");
        new BlockStairs(86, 7).setBlockName("brickStairs");
        new BlockStairs(87, 224).setBlockName("netherBrickStairs");
        new BlockStairs(88, 6).setBlockName("stoneStairs");
        new BlockStairs(89, 16).setBlockName("cobblestoneStairs");
        new BlockStairs(90, 64).setBlockName("whiteWoolStairs");
        new BlockStairs(91, 113).setBlockName("blackWoolStairs");
        new BlockStairs(92, 129).setBlockName("redWoolStairs");
        new BlockStairs(93, 177).setBlockName("blueWoolStairs");
        new BlockStairs(94, 162).setBlockName("yellowWoolStairs");
        new BlockStairs(95, 145).setBlockName("greenWoolStairs");
        new BlockStairs(96, 146).setBlockName("lightGreenWoolStairs");
        new BlockStairs(97, 210).setBlockName("orangeWoolStairs");
        new BlockStairs(98, 130).setBlockName("pinkWoolStairs");
        new BlockSlab(99, 64).setBlockName("whiteWoolSlab");
        new BlockSlab(100, 113).setBlockName("blackWoolSlab");
        new BlockSlab(101, 129).setBlockName("redWoolSlab");
        new BlockSlab(102, 177).setBlockName("blueWoolSlab");
        new BlockSlab(103, 162).setBlockName("yellowWoolSlab");
        new BlockSlab(104, 145).setBlockName("greenWoolSlab");
        new BlockSlab(105, 146).setBlockName("lightGreenWoolSlab");
        new BlockSlab(106, 210).setBlockName("orangeWoolSlab");
        new BlockSlab(107, 130).setBlockName("pinkWoolSlab");
        new BlockTNT(108, 265, 266, 267, 281, 282, 283, 1, 1).setBlockName("tntWeak");
        new BlockTNT(109, 268, 269, 270, 284, 285, 286, 6, 5).setBlockName("tntStrong");
        new BlockFurnance(110, 274, 273, 272, 272, 275).setBlockName("chest");
        new BlockEmoticon(111, 280, 272, 272, 272, new int[]{279, 275, 276, 277, 278, 271, 287}).setBlockName("emoticon");
        new BlockAlphabet(112, 288, 272, 272, 272, new int[]{288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300}).setBlockName("alphabet1");
        new BlockAlphabet(113, 301, 272, 272, 272, new int[]{301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313}).setBlockName("alphabet2");
        new BlockAlphabet(114, 314, 272, 272, 272, new int[]{314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327}).setBlockName("numbers");
        new BlockFence(115, 328).setBlockName("fencePlank");
        new BlockFence(116, 329).setBlockName("fencePlank2");
        new BlockFence(117, 330).setBlockName("fencePlank3");
        new BlockFence(118, 331).setBlockName("fencePlank4");
        new BlockWheat(119, new int[]{88, 89, 90, 91, 92, 93, 94, 95}).setBlockName("wheat");
        new BlockFence(120, 332).setBlockName("fenceNetherbrick");
        new BlockFence(121, 333).setBlockName("fenceStone");
        new BlockFence(122, 334).setBlockName("fenceBrick");
        new BlockAnimal(123, 337, 336, 338, 336, 336).setBlockName("animalSheep");
        new BlockBed(124, 135, 134, 149, 152, 150, 151, 335, 351).setBlockName("bed");
        new BlockAnimal(125, 339, 341, 340, 357, 357).setBlockName("animalChicken");
        new BlockAnimal(126, 342, 344, 343, 344, 344).setBlockName("animalCow");
        new BlockAnimal(127, 345, 348, 346, 347, 347).setBlockName("animalPig");
        new BlockPlayer().setBlockName("Player");
        InvItem.itemsList[Block.getBlock((String)"stoneSlab").blockID] = new InvItemSlab(Block.getBlock((String)"stoneSlab").blockID - 256, Block.getBlock("doubleStoneSlab"));
        InvItem.itemsList[Block.getBlock((String)"plankSlab").blockID] = new InvItemSlab(Block.getBlock((String)"plankSlab").blockID - 256, Block.getBlock("planks"));
        InvItem.itemsList[Block.getBlock((String)"cobblestoneSlab").blockID] = new InvItemSlab(Block.getBlock((String)"cobblestoneSlab").blockID - 256, Block.getBlock("cobblestone"));
        InvItem.itemsList[Block.getBlock((String)"plankSlab1").blockID] = new InvItemSlab(Block.getBlock((String)"plankSlab1").blockID - 256, Block.getBlock("planks1"));
        InvItem.itemsList[Block.getBlock((String)"plankSlab2").blockID] = new InvItemSlab(Block.getBlock((String)"plankSlab2").blockID - 256, Block.getBlock("planks2"));
        InvItem.itemsList[Block.getBlock((String)"plankSlab3").blockID] = new InvItemSlab(Block.getBlock((String)"plankSlab3").blockID - 256, Block.getBlock("planks3"));
        InvItem.itemsList[Block.getBlock((String)"netherBrickSlab").blockID] = new InvItemSlab(Block.getBlock((String)"netherBrickSlab").blockID - 256, Block.getBlock("netherBrick"));
        InvItem.itemsList[Block.getBlock((String)"brickSlab").blockID] = new InvItemSlab(Block.getBlock((String)"brickSlab").blockID - 256, Block.getBlock("brick"));
        InvItem.itemsList[Block.getBlock((String)"woodenDoor").blockID] = new InvItemBlock(Block.getBlock((String)"woodenDoor").blockID - 256, 43);
        InvItem.itemsList[Block.getBlock((String)"ironDoor").blockID] = new InvItemBlock(Block.getBlock((String)"ironDoor").blockID - 256, 44);
        InvItem.itemsList[Block.getBlock((String)"water").blockID] = new InvItemBlock(Block.getBlock((String)"water").blockID - 256, 75);
        InvItem.itemsList[Block.getBlock((String)"lava").blockID] = new InvItemBlock(Block.getBlock((String)"lava").blockID - 256, 76);
        InvItem.itemsList[Block.getBlock((String)"bed").blockID] = new InvItemBlock(Block.getBlock((String)"bed").blockID - 256, 45);
        int i = 0;
        while (i < 256) {
            if (blocksList[i] != null && InvItem.itemsList[i] == null) {
                InvItem.itemsList[i] = new InvItemBlock(i - 256);
            }
            ++i;
        }
    }

    protected Block(int id) {
        this(id, 0);
    }

    protected Block(int id, int index) {
        this(BLOCK_PROTOTYPE);
        int[] nArray;
        if (index != 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = index;
        } else {
            nArray = null;
        }
        this.createBlock(id, nArray);
    }

    private void createBlock(int id, int[] textures) {
        if (id == 0) {
            throw new ComcraftException("Cannot create block 0 because 0 is air!", null);
        }
        if (blocksList[id] != null) {
            throw new ComcraftException("Block ID is already in use! Id: " + id, null);
        }
        Block.blocksList[id] = this;
        this.IdDropped = this.blockID = id;
        this.UsedTexturesList = textures != null ? textures : new int[]{};
        this.addVar("blockID", new Integer(this.blockID));
        this.addVar("IdDropped", new Integer(this.IdDropped));
    }

    public Block(JsObject __proto__) {
        super(__proto__);
    }

    public boolean collidesWithPlayer() {
        return this.collidesWithPlayer;
    }

    public boolean doesBlockDestroyGrass() {
        return this.doesBlockDestroyGrass;
    }

    public boolean isReplaceableBlock() {
        return this.isReplaceableBlock;
    }

    public boolean isUpdatableBlock() {
        return this.isUpdatableBlock;
    }

    public boolean canBePieced() {
        return this.canBePieced;
    }

    public boolean canBePiecedVertically() {
        return this.canBePiecedVertically;
    }

    public Transform getBlockTransform(World world, int x, int y, int z, Transform transform, int side) {
        this.eh.runEvent("getBlockTransform", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new com.simon816.minijoe.nativetypes.Transform(transform), new Integer(side)});
        Object success = this.eh.getLastSuccess("getBlockTransform");
        if (success == null) {
            return transform;
        }
        return ((com.simon816.minijoe.nativetypes.Transform)success)._getTransform();
    }

    public VertexBuffer[][][][] getBlockVertexBufferPieced(World world, int x, int y, int z) {
        return this.BlockVertexBufferPieced;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        if (this.BlockVertexBufferSided == null) {
            return this.getBlockVertexBufferPieced(world, x, y, z)[0][0][0];
        }
        return this.BlockVertexBufferSided;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return this.BlockIndexBuffer;
    }

    public String getBlockName() {
        return this.blockName;
    }

    protected void setBlockName(String name) {
        this.blockName = name;
    }

    public int getIdDropped() {
        return this.IdDropped;
    }

    public int getBlockTexture(World world, int x, int y, int z, int side) {
        this.eh.runEvent("getBlockTexture", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(side)});
        Object success = this.eh.getLastSuccess("getBlockTexture");
        if (success == null) {
            return this.UsedTexturesList[0];
        }
        return ((Double)success).intValue();
    }

    public boolean isNormal() {
        return this.isNormal;
    }

    public int getRenderType() {
        return this.RenderType;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        this.eh.runEvent("shouldSideBeRendered", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(side)});
        Object success = this.eh.getLastSuccess("shouldSideBeRendered");
        if (success == null) {
            return !world.isBlockNormal(x, y, z);
        }
        return (Boolean)success;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        this.eh.runEvent("getCollisionBoundingBoxFromPool", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
        Object success = this.eh.getLastSuccess("getCollisionBoundingBoxFromPool");
        if (success == null) {
            return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
        }
        return (AxisAlignedBB)success;
    }

    public boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        this.eh.runEvent("canPlaceBlockOnSide", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(side)});
        Object success = this.eh.getLastSuccess("canPlaceBlockOnSide");
        if (success == null) {
            return this.canPlaceBlockAt(world, x, y, z);
        }
        return (Boolean)success;
    }

    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        this.eh.runEvent("canPlaceBlockAt", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
        Object success = this.eh.getLastSuccess("canPlaceBlockAt");
        if (success == null) {
            int i = world.getBlockID(x, y, z);
            return i == 0 || blocksList[i].isReplaceableBlock();
        }
        return (Boolean)success;
    }

    public void onBlockPlaced(World world, int x, int y, int z, int side) {
        this.eh.runEvent("onBlockPlaced", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(side)});
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        this.eh.runEvent("onBlockPlacedBy", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), entityPlayer});
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metadata) {
        this.eh.runEvent("onBlockDestroyedByPlayer", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(metadata)});
    }

    public boolean blockActivated(World world, int x, int y, int z, EntityPlayer entityplayer, InvItemStack itemStack) {
        this.eh.runEvent("blockActivated", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), entityplayer, itemStack});
        Object success = this.eh.getLastSuccess("blockActivated");
        if (success == null) {
            return false;
        }
        return (Boolean)success;
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, int blockID) {
        this.eh.runEvent("onNeighborBlockChange", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z), new Integer(blockID)});
    }

    public void onBlockRemoval(World world, int x, int y, int z) {
        this.eh.runEvent("onBlockRemoval", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
    }

    public void onBlockAdded(World world, int x, int y, int z) {
        this.eh.runEvent("onBlockAdded", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
    }

    public String getBlockDestroyingSound() {
        return this.blockDestroyingSound;
    }

    public String getBlockPlacingSound() {
        return this.blockPlacingSound;
    }

    public void tickBlock(World world, int x, int y, int z) {
        this.eh.runEvent("tickBlock", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
    }

    public int[] getUsedTexturesList() {
        return this.UsedTexturesList;
    }

    public Node getBlockModel(World world, int x, int y, int z) {
        this.eh.runEvent("getBlockModel", this, new Object[]{world, new Integer(x), new Integer(y), new Integer(z)});
        Object success = this.eh.getLastSuccess("getBlockModel");
        if (success == null) {
            return null;
        }
        return (Node)success;
    }

    public static Block getBlock(String name) {
        int i = 0;
        while (i < blocksList.length) {
            String bname;
            if (blocksList[i] != null && (bname = blocksList[i].getBlockName()) != null && bname.equals(name)) {
                return blocksList[i];
            }
            ++i;
        }
        return null;
    }

    private void ensureArguments(String fn, int minarg, int maxarg, int actarg) {
        String s = "";
        if (actarg < minarg) {
            s = "at least";
        } else if (actarg > maxarg) {
            s = "at most";
        } else {
            return;
        }
        if (minarg == maxarg) {
            s = "exactly";
        }
        throw new JsException((Object)(String.valueOf(fn) + "() takes " + s + " " + minarg + " arguments (" + actarg + " given)"));
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 160: {
                stack.setObject(sp, (Object)Block.getBlock(stack.getString(sp + 2)));
                break;
            }
            case 100: {
                this.ensureArguments("new Block", 2, 3, parCount);
                if (!stack.isNumber(sp + 2)) {
                    throw new JsException((Object)"new Block() argument 1 (blockID) has to be an integer");
                }
                int[] textures = null;
                if (parCount >= 2) {
                    Object par2 = stack.getObject(sp + 3);
                    if (par2 instanceof Double) {
                        textures = new int[]{((Double)par2).intValue()};
                    } else if (par2 instanceof JsArray) {
                        textures = ModArray.toIntArray((JsArray)par2);
                    } else {
                        throw new JsException((Object)"new Block() argument 2 must be of type Integer or Array of integers");
                    }
                }
                if (parCount == 3) {
                    this.loadObject(stack.getJsObject(sp + 4));
                }
                this.createBlock(stack.getInt(sp + 2), textures);
                InvItem.itemsList[this.blockID] = new InvItemBlock(this.blockID - 256);
                break;
            }
            case 102: {
                stack.setBoolean(sp, this.collidesWithPlayer());
                break;
            }
            case 103: {
                this.collidesWithPlayer = stack.getBoolean(sp);
                break;
            }
            case 101: {
                stack.setObject(sp, (Object)this.getBlockName());
                break;
            }
            case 104: {
                stack.setBoolean(sp, this.doesBlockDestroyGrass());
                break;
            }
            case 105: {
                this.doesBlockDestroyGrass = stack.getBoolean(sp + 2);
                break;
            }
            case 106: {
                stack.setBoolean(sp, this.isReplaceableBlock());
                break;
            }
            case 107: {
                this.isReplaceableBlock = stack.getBoolean(sp);
                break;
            }
            case 108: {
                stack.setBoolean(sp, this.isUpdatableBlock());
                break;
            }
            case 109: {
                this.isUpdatableBlock = stack.getBoolean(sp);
                break;
            }
            case 110: {
                stack.setBoolean(sp, this.canBePieced());
                break;
            }
            case 111: {
                this.canBePieced = stack.getBoolean(sp);
                break;
            }
            case 112: {
                stack.setBoolean(sp, this.canBePiecedVertically());
                break;
            }
            case 113: {
                this.canBePiecedVertically = stack.getBoolean(sp);
                break;
            }
            case 114: {
                stack.setBoolean(sp, this.isNormal());
                break;
            }
            case 115: {
                this.isNormal = stack.getBoolean(sp);
                break;
            }
            case 116: {
                stack.setInt(sp, this.getRenderType());
                break;
            }
            case 117: {
                this.RenderType = stack.getInt(sp);
                break;
            }
            case 118: {
                stack.setInt(sp, this.getIdDropped());
                break;
            }
            case 119: {
                this.IdDropped = stack.getInt(sp);
                break;
            }
            case 120: {
                stack.setObject(sp, (Object)this.getBlockPlacingSound());
                break;
            }
            case 121: {
                this.blockPlacingSound = stack.getString(sp);
                break;
            }
            case 122: {
                stack.setObject(sp, (Object)this.getBlockDestroyingSound());
                break;
            }
            case 123: {
                this.blockDestroyingSound = stack.getString(sp);
                break;
            }
            case 124: {
                stack.setObject(sp, (Object)this.BlockVertexBufferPieced);
                break;
            }
            case 125: {
                this.BlockVertexBufferPieced = (VertexBuffer[][][][])stack.getObject(sp);
                break;
            }
            case 126: {
                stack.setObject(sp, (Object)this.BlockVertexBufferSided);
                break;
            }
            case 127: {
                this.BlockVertexBufferSided = (VertexBuffer[])stack.getObject(sp);
                break;
            }
            case 128: {
                stack.setObject(sp, (Object)this.BlockIndexBuffer);
                break;
            }
            case 129: {
                this.BlockIndexBuffer = (IndexBuffer)stack.getObject(sp);
                break;
            }
            case 131: {
                this.eh.setEvent("getBlockTransform", (JsFunction)stack.getObject(sp));
                break;
            }
            case 133: {
                this.eh.setEvent("getBlockTexture", (JsFunction)stack.getObject(sp));
                break;
            }
            case 135: {
                this.eh.setEvent("shouldSideBeRendered", (JsFunction)stack.getObject(sp));
                break;
            }
            case 137: {
                this.eh.setEvent("getCollisionBoundingBoxFromPool", (JsFunction)stack.getObject(sp));
                break;
            }
            case 138: {
                if (stack.size() == 0) {
                    stack.setObject(sp, (Object)new JsFunction(138, 4));
                    break;
                }
                stack.setBoolean(sp, this.canPlaceBlockAt((World)stack.getObject(sp + 2), stack.getInt(sp + 3), stack.getInt(sp + 4), stack.getInt(sp + 5)));
                break;
            }
            case 139: {
                this.eh.setEvent("canPlaceBlockAt", (JsFunction)stack.getObject(sp));
                break;
            }
            case 141: {
                this.eh.setEvent("canPlaceBlockOnSide", (JsFunction)stack.getObject(sp));
                break;
            }
            case 143: {
                this.eh.setEvent("blockActivated", (JsFunction)stack.getObject(sp));
                break;
            }
            case 145: {
                this.eh.setEvent("onBlockPlaced", (JsFunction)stack.getObject(sp));
                break;
            }
            case 147: {
                this.eh.setEvent("onBlockPlacedBy", (JsFunction)stack.getObject(sp));
                break;
            }
            case 149: {
                this.eh.setEvent("onBlockDestroyedByPlayer", (JsFunction)stack.getObject(sp));
                break;
            }
            case 151: {
                this.eh.setEvent("onNeighborBlockChange", (JsFunction)stack.getObject(sp));
                break;
            }
            case 153: {
                this.eh.setEvent("onBlockRemoval", (JsFunction)stack.getObject(sp));
                break;
            }
            case 155: {
                this.eh.setEvent("onBlockAdded", (JsFunction)stack.getObject(sp));
                break;
            }
            case 157: {
                this.eh.setEvent("tickBlock", (JsFunction)stack.getObject(sp));
                break;
            }
            case 159: {
                this.eh.setEvent("getBlockModel", (JsFunction)stack.getObject(sp));
                break;
            }
            case 130: 
            case 132: 
            case 134: 
            case 136: 
            case 140: 
            case 142: 
            case 144: 
            case 146: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 158: {
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }

    private void loadObject(JsObject properties) {
        Object v = properties.getObject("collidesWithPlayer");
        if (v != null) {
            this.collidesWithPlayer = (Boolean)v;
        }
        if ((v = properties.getObject("doesBlockDestroyGrass")) != null) {
            this.doesBlockDestroyGrass = (Boolean)v;
        }
        if ((v = properties.getObject("isReplaceableBlock")) != null) {
            this.isReplaceableBlock = (Boolean)v;
        }
        if ((v = properties.getObject("isUpdatableBlock")) != null) {
            this.isUpdatableBlock = (Boolean)v;
        }
        if ((v = properties.getObject("canBePieced")) != null) {
            this.canBePieced = (Boolean)v;
        }
        if ((v = properties.getObject("canBePiecedVertically")) != null) {
            this.canBePiecedVertically = (Boolean)v;
        }
        if ((v = properties.getObject("isNormal")) != null) {
            this.isNormal = (Boolean)v;
        }
        if ((v = properties.getObject("RenderType")) != null) {
            this.RenderType = ((Double)v).intValue();
        }
        if ((v = properties.getObject("IdDropped")) != null) {
            this.IdDropped = ((Double)v).intValue();
        }
        if ((v = properties.getObject("blockPlacingSound")) != null) {
            this.blockPlacingSound = (String)v;
        }
        if ((v = properties.getObject("blockDestroyingSound")) != null) {
            this.blockDestroyingSound = (String)v;
        }
        if ((v = properties.getObject("getBlockVertexBufferPieced")) != null) {
            this.BlockVertexBufferPieced = (VertexBuffer[][][][])v;
        }
        if ((v = properties.getObject("getBlockVertexBufferSided")) != null) {
            this.BlockVertexBufferSided = (VertexBuffer[])v;
        }
        if ((v = properties.getObject("getBlockIndexBuffer")) != null) {
            this.BlockIndexBuffer = (IndexBuffer)v;
        }
        this.eh.setEvent("getBlockTransform", (JsFunction)properties.getObject("getBlockTransform"));
        this.eh.setEvent("getBlockTexture", (JsFunction)properties.getObject("getBlockTexture"));
        this.eh.setEvent("shouldSideBeRendered", (JsFunction)properties.getObject("shouldSideBeRendered"));
        this.eh.setEvent("getCollisionBoundingBoxFromPool", (JsFunction)properties.getObject("getCollisionBoundingBoxFromPool"));
        this.eh.setEvent("canPlaceBlockAt", (JsFunction)properties.getObject("canPlaceBlockAt"));
        this.eh.setEvent("canPlaceBlockOnSide", (JsFunction)properties.getObject("canPlaceBlockOnSide"));
        this.eh.setEvent("blockActivated", (JsFunction)properties.getObject("blockActivated"));
        this.eh.setEvent("onBlockPlaced", (JsFunction)properties.getObject("onBlockPlaced"));
        this.eh.setEvent("onBlockPlacedBy", (JsFunction)properties.getObject("onBlockPlacedBy"));
        this.eh.setEvent("onBlockDestroyedByPlayer", (JsFunction)properties.getObject("onBlockDestroyedByPlayer"));
        this.eh.setEvent("onNeighborBlockChange", (JsFunction)properties.getObject("onNeighborBlockChange"));
        this.eh.setEvent("onBlockRemoval", (JsFunction)properties.getObject("onBlockRemoval"));
        this.eh.setEvent("onBlockAdded", (JsFunction)properties.getObject("onBlockAdded"));
        this.eh.setEvent("tickBlock", (JsFunction)properties.getObject("tickBlock"));
        this.eh.setEvent("getBlockModel", (JsFunction)properties.getObject("getBlockModel"));
        v = properties.getObject("textures");
        if (v != null) {
            this.UsedTexturesList = ModArray.toIntArray((JsArray)v);
        }
    }

    public String toString() {
        return "[object Block {blockName=" + this.blockName + ", blockID=" + this.blockID + "}]";
    }
}

