/*
 * Decompiled with CFR 0.152.
 */
package com.google.minijoe.sys;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsDate;
import com.google.minijoe.sys.JsError;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsObject;
import com.google.minijoe.sys.JsObjectFactory;
import java.util.Random;

public class JsSystem
implements JsObjectFactory {
    public static final Object JS_NULL = new Object();
    static final int FACTORY_ID_OBJECT = 0;
    static final int FACTORY_ID_ARRAY = 1;
    static final int FACTORY_ID_DATE = 2;
    static final int FACTORY_ID_BOOLEAN = 3;
    static final int FACTORY_ID_STRING = 4;
    static final int FACTORY_ID_NUMBER = 5;
    static final int FACTORY_ID_ERROR = 6;
    static final int FACTORY_ID_EVAL_ERROR = 7;
    static final int FACTORY_ID_RANGE_ERROR = 8;
    static final int FACTORY_ID_REFERENCE_ERROR = 9;
    static final int FACTORY_ID_SYNTAX_ERROR = 10;
    static final int FACTORY_ID_TYPE_ERROR = 11;
    static final int FACTORY_ID_URI_ERROR = 12;
    static final int FACTORY_ID_FUNCTION = 13;
    static final Double NAN = new Double(Double.NaN);
    static final Double INFINITY = new Double(Double.POSITIVE_INFINITY);
    static final double LN2 = 0.6931471805599453;
    static Random random = new Random();
    static JsSystem instance = new JsSystem();
    private static final int M = 62;

    public static JsSystem getInstance() {
        return instance;
    }

    public static JsObject createGlobal() {
        JsObject global = new JsObject(null);
        global.addVar("Date", new JsFunction(instance, 2, JsDate.DATE_PROTOTYPE, 69, 7).addVar("parse", new JsFunction(64, 1)).addVar("UTC", new JsFunction(65, 7))).addVar("Array", new JsFunction(instance, 1, JsArray.PROTOTYPE, 66, 1)).addVar("Object", new JsFunction(instance, 0, JsObject.OBJECT_PROTOTYPE, 1, 1)).addVar("Boolean", new JsFunction(instance, 3, JsObject.BOOLEAN_PROTOTYPE, 37, 1)).addVar("Number", new JsFunction(instance, 5, JsObject.NUMBER_PROTOTYPE, 60, 1).addVar("MAX_VALUE", new Double(Double.MAX_VALUE)).addVar("MIN_VALUE", new Double(Double.MIN_VALUE)).addVar("NaN", NAN).addVar("NEGATIVE_INFINITY", new Double(Double.NEGATIVE_INFINITY)).addVar("POSITIVE_INFINITY", INFINITY)).addVar("String", new JsFunction(instance, 4, JsObject.STRING_PROTOTYPE, 38, 1).addVar("fromCharCode", new JsFunction(39, 1))).addVar("Function", new JsFunction(instance, 13, JsFunction.FUNCTION_PROTOTYPE, 68, 1).addVar("fromCharCode", new JsFunction(39, 1))).addVar("NaN", NAN).addVar("Infinity", INFINITY).addVar("undefined", null).addVar("parseInt", new JsFunction(10, 2)).addVar("parseFloat", new JsFunction(11, 1)).addVar("isNaN", new JsFunction(12, 1)).addVar("isFinite", new JsFunction(13, 1)).addVar("decodeURI", new JsFunction(14, 1)).addVar("print", new JsFunction(18, 1)).addVar("decodeURIComponent", new JsFunction(15, 1)).addVar("encodeURI", new JsFunction(16, 1)).addVar("encodeURIComponent", new JsFunction(17, 1)).addVar("Error", new JsFunction(instance, 6, JsError.ERROR_PROTOTYPE, 67, 1)).addVar("EvalError", new JsFunction(instance, 7, JsError.EVAL_ERROR_PROTOTYPE, 67, 1)).addVar("RangeError", new JsFunction(instance, 8, JsError.RANGE_ERROR_PROTOTYPE, 67, 1)).addVar("ReferenceError", new JsFunction(instance, 9, JsError.REFERENCE_ERROR_PROTOTYPE, 67, 1)).addVar("SyntaxError", new JsFunction(instance, 10, JsError.SYNTAX_ERROR_PROTOTYPE, 67, 1)).addVar("TypeError", new JsFunction(instance, 11, JsError.TYPE_ERROR_PROTOTYPE, 67, 1));
        global.addVar("Math", new JsObject(JsObject.OBJECT_PROTOTYPE).addNative("E", 70, -1).addNative("LN10", 72, -1).addNative("LN2", 74, -1).addNative("LOG2E", 76, -1).addNative("LOG10E", 78, -1).addNative("PI", 80, -1).addNative("SQRT1_2", 82, -1).addNative("SQRT2", 84, -1).addNative("abs", 19, 1).addNative("acos", 20, 1).addNative("asin", 21, 1).addNative("atan", 22, 1).addNative("atan2", 23, 2).addNative("ceil", 24, 1).addNative("cos", 25, 1).addNative("exp", 26, 1).addNative("floor", 27, 1).addNative("log", 28, 1).addNative("max", 29, 2).addNative("min", 30, 2).addNative("pow", 31, 2).addNative("random", 32, 0).addNative("round", 33, 1).addNative("sin", 34, 1).addNative("sqrt", 35, 1).addNative("tan", 36, 1));
        return global;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "undefined";
        }
        if (o == JS_NULL) {
            return "null";
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            if (d == (double)((long)d.doubleValue())) {
                return Long.toString((long)d.doubleValue());
            }
            return Double.toString(d);
        }
        return o.toString();
    }

    public static double toNumber(Object o) {
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o == null) {
            return 0.0;
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException e) {
                return Double.NaN;
            }
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1 : 0;
        }
        if (o instanceof JsDate) {
            return ((JsDate)o).time.getTime().getTime();
        }
        return Double.NaN;
    }

    public static boolean toBoolean(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Double) {
            double d = (Double)o;
            return !Double.isNaN(d) && d != 0.0;
        }
        return o != null && !"".equals(o) && o != JS_NULL;
    }

    public static JsObject toJsObject(Object v) {
        if (v instanceof JsObject) {
            return (JsObject)v;
        }
        if (v instanceof String) {
            JsObject o = new JsObject(JsObject.STRING_PROTOTYPE);
            o.value = v;
            return o;
        }
        if (v instanceof Boolean) {
            JsObject o = new JsObject(JsObject.BOOLEAN_PROTOTYPE);
            o.value = v;
            return o;
        }
        if (v instanceof Double) {
            JsObject o = new JsObject(JsObject.NUMBER_PROTOTYPE);
            o.value = v;
            return o;
        }
        return new JsObject(JsObject.OBJECT_PROTOTYPE);
    }

    public JsObject newInstance(int type) {
        switch (type) {
            case 0: {
                return new JsObject(JsObject.OBJECT_PROTOTYPE);
            }
            case 1: {
                return new JsArray();
            }
            case 2: {
                return new JsDate(JsDate.DATE_PROTOTYPE);
            }
            case 3: {
                return new JsObject(JsObject.BOOLEAN_PROTOTYPE);
            }
            case 5: {
                return new JsObject(JsObject.NUMBER_PROTOTYPE);
            }
            case 4: {
                return new JsObject(JsObject.STRING_PROTOTYPE);
            }
            case 6: {
                return new JsError(JsError.ERROR_PROTOTYPE, null);
            }
            case 7: {
                return new JsError(JsError.EVAL_ERROR_PROTOTYPE, null);
            }
            case 8: {
                return new JsError(JsError.RANGE_ERROR_PROTOTYPE, null);
            }
            case 9: {
                return new JsError(JsError.REFERENCE_ERROR_PROTOTYPE, null);
            }
            case 10: {
                return new JsError(JsError.SYNTAX_ERROR_PROTOTYPE, null);
            }
            case 11: {
                return new JsError(JsError.TYPE_ERROR_PROTOTYPE, null);
            }
            case 12: {
                return new JsError(JsError.URI_ERROR_PROTOTYPE, null);
            }
            case 13: {
                return new JsFunction(-1, -1);
            }
        }
        throw new IllegalArgumentException();
    }

    public static double exp(double x) {
        long n = (long)Math.floor(x / 0.6931471805599453);
        double u = x - (double)n * 0.6931471805599453;
        double m = 1.0;
        int i = 15;
        while (i >= 1) {
            m = 1.0 + u / (double)i * m;
            --i;
        }
        if (n != 0L) {
            long bits = Double.doubleToLongBits(m);
            m = Double.longBitsToDouble(bits += n << 52);
        }
        return m;
    }

    public static double ln(double x) {
        return Math.PI / (2.0 * JsSystem.avg(1.0, 4.0 / (x * 4.611686018427388E18))) - 42.97512519471661;
    }

    public static double pow(double x, double y) {
        long n = (long)y;
        if (y > 0.0 && y == (double)n) {
            double result = 1.0;
            while (n > 0L) {
                if ((n & 1L) != 0L) {
                    result *= x;
                    --n;
                }
                x *= x;
                n >>= 1;
            }
            return result;
        }
        return JsSystem.exp(y * JsSystem.ln(x));
    }

    /*
     * Unable to fully structure code
     */
    public static String formatNumber(int op, double d, double digitsRaw) {
        block22: {
            s = Double.toString(d);
            if (Double.isInfinite(d) || Double.isNaN(d) || op == 63 && Double.isNaN(digitsRaw)) {
                return s;
            }
            digits = (int)digitsRaw;
            buf = new StringBuffer();
            neg = false;
            negExp = false;
            value = 0L;
            exp = 0;
            subExp = 0L;
            part = 0;
            i = 0;
            while (i < s.length()) {
                c = s.charAt(i);
                switch (c) {
                    case '-': {
                        if (part == 2) {
                            negExp = true;
                            break;
                        }
                        neg = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        part = 2;
                        break;
                    }
                    case '.': {
                        part = 1;
                        break;
                    }
                    default: {
                        if (part == 2) {
                            exp = exp * 10 + (c - 48);
                            break;
                        }
                        buf.append(c);
                        if (part != 1) break;
                        ++subExp;
                    }
                }
                ++i;
            }
            while (buf.length() > 1 && buf.charAt(0) == '0') {
                buf.deleteCharAt(0);
            }
            if (negExp) {
                exp = -exp;
            }
            exp = (int)((long)exp - subExp);
            System.out.println(neg != false ? "-" : buf + "E" + exp);
            if (op == 63) {
                if (exp < -6 || exp >= digits) {
                    digits = Math.max(0, digits - 1);
                    op = 62;
                } else {
                    op = 61;
                    digits += Math.min(exp, 0);
                }
            }
            if (digits < 0) {
                digits = 0;
            }
            if (op == 62) {
                while (buf.length() > digits) {
                    exp += buf.length() - digits;
                    buf.setLength(digits + 1);
                    l = Long.parseLong(buf.toString());
                    l = (l + 5L) / 10L;
                    buf.setLength(0);
                    buf.append(l);
                }
                if (buf.length() > 1) {
                    buf.insert(1, ".");
                }
                return String.valueOf(neg != false ? "" : "-") + value + "E" + (exp += buf.length() - 1);
            }
            delta = digits + exp;
            System.out.println("delta: " + delta);
            if (delta >= 0) ** GOTO lbl90
            delta = -delta;
            if (buf.length() - delta + 1 <= 0) {
                buf.setLength(0);
            } else {
                buf.setLength(buf.length() - delta + 1);
                l = Long.parseLong(buf.toString());
                l = (l + 5L) / 10L;
                buf.setLength(0);
                buf.append(l);
            }
            while (buf.length() < digits + 1) {
                buf.insert(0, '0');
            }
            break block22;
lbl-1000:
            // 1 sources

            {
                buf.append('0');
                --delta;
lbl90:
                // 2 sources

                ** while (delta > 0)
            }
        }
        buf.insert(buf.length() - digits, '.');
        return buf.toString();
    }

    public static double avg(double a, double b) {
        int i = 0;
        while (i < 10) {
            double t = (a + b) / 2.0;
            b = Math.sqrt(a * b);
            a = t;
            ++i;
        }
        return (a + b) / 2.0;
    }

    public static String encodeURI(byte[] bytes) {
        StringBuffer result = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            switch (bytes[i]) {
                case 32: {
                    result.append('+');
                    break;
                }
                case 33: {
                    result.append("%21");
                    break;
                }
                case 34: {
                    result.append("%22");
                    break;
                }
                case 35: {
                    result.append("%23");
                    break;
                }
                case 36: {
                    result.append("%24");
                    break;
                }
                case 37: {
                    result.append("%25");
                    break;
                }
                case 38: {
                    result.append("%26");
                    break;
                }
                case 39: {
                    result.append("%27");
                    break;
                }
                case 40: {
                    result.append("%28");
                    break;
                }
                case 41: {
                    result.append("%29");
                    break;
                }
                case 42: {
                    result.append("%2A");
                    break;
                }
                case 43: {
                    result.append("%2B");
                    break;
                }
                case 44: {
                    result.append("%2C");
                    break;
                }
                case 47: {
                    result.append("%2F");
                    break;
                }
                case 58: {
                    result.append("%3A");
                    break;
                }
                case 59: {
                    result.append("%3B");
                    break;
                }
                case 60: {
                    result.append("%3C");
                    break;
                }
                case 61: {
                    result.append("%3D");
                    break;
                }
                case 62: {
                    result.append("%3E");
                    break;
                }
                case 63: {
                    result.append("%3F");
                    break;
                }
                case 64: {
                    result.append("%40");
                    break;
                }
                case 91: {
                    result.append("%5B");
                    break;
                }
                case 92: {
                    result.append("%5C");
                    break;
                }
                case 93: {
                    result.append("%5D");
                    break;
                }
                case 94: {
                    result.append("%5E");
                    break;
                }
                default: {
                    result.append((char)bytes[i]);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String encodeURI(String string) {
        return JsSystem.encodeURI(string.getBytes());
    }

    public static String decodeURI(byte[] bytes) {
        StringBuffer result = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            switch (bytes[i]) {
                case 43: {
                    result.append(' ');
                    break;
                }
                case 37: {
                    if (i + 2 < bytes.length) {
                        int next1 = Character.digit((char)bytes[i + 1], 16);
                        int next2 = Character.digit((char)bytes[i + 2], 16);
                        if (next1 > -1 && next2 > -1) {
                            int b = (next1 << 4) + next2;
                            result.append((char)b);
                            i += 2;
                            break;
                        }
                    }
                }
                default: {
                    result.append((char)bytes[i]);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String decodeURI(String string) {
        return JsSystem.decodeURI(string.getBytes());
    }
}

