/*
 * Decompiled with CFR 0.152.
 */
package com.google.minijoe.sys;

import com.google.minijoe.sys.JsDate;
import com.google.minijoe.sys.JsFunction;
import com.google.minijoe.sys.JsObject;
import com.google.minijoe.sys.JsSystem;
import java.util.Enumeration;
import java.util.Vector;

public class JsArray
extends JsObject {
    private static final int INITIAL_SPACE = 16;
    private static final int ID_JOIN = 405;
    private static final int ID_POP = 406;
    private static final int ID_PUSH = 407;
    private static final int ID_REVERSE = 408;
    private static final int ID_SHIFT = 409;
    private static final int ID_SORT = 411;
    private static final int ID_SPLICE = 412;
    private static final int ID_UNSHIFT = 413;
    public static final JsObject PROTOTYPE = new JsObject(JsObject.OBJECT_PROTOTYPE).addVar("length", new JsFunction(56, -1)).addVar("concat", new JsFunction(42, 1)).addVar("join", new JsFunction(405, 0)).addVar("pop", new JsFunction(406, 0)).addVar("push", new JsFunction(407, 1)).addVar("reverse", new JsFunction(408, 0)).addVar("shift", new JsFunction(409, 0)).addVar("slice", new JsFunction(49, 2)).addVar("sort", new JsFunction(411, 1)).addVar("splice", new JsFunction(412, 2)).addVar("unshift", new JsFunction(413, 1));
    private static final Object NUMBER_MARKER = new Object();
    private Object[] objects = new Object[16];
    private double[] numbers = new double[16];
    private int size;

    public JsArray() {
        super(PROTOTYPE);
    }

    public final boolean getBoolean(int i) {
        if (i >= this.size) {
            return false;
        }
        Object o = this.objects[i];
        if (o == NUMBER_MARKER) {
            double d = this.numbers[i];
            return d != 0.0 && !Double.isNaN(d);
        }
        if (o == Boolean.TRUE) {
            return true;
        }
        if (o == Boolean.FALSE) {
            return false;
        }
        return JsSystem.toBoolean(o);
    }

    public JsObject getJsObject(int i) {
        return JsSystem.toJsObject(this.getObject(i));
    }

    public final double getNumber(int i) {
        if (i >= this.size) {
            return 0.0;
        }
        Object o = this.objects[i];
        return o == NUMBER_MARKER ? this.numbers[i] : JsSystem.toNumber(o);
    }

    public int size() {
        return this.size;
    }

    public final int getInt(int i) {
        double d = this.getNumber(i);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return 0;
        }
        return (int)d;
    }

    public final Object getObject(int i) {
        if (i >= this.size) {
            return null;
        }
        Object o = this.objects[i];
        return o == NUMBER_MARKER ? new Double(this.numbers[i]) : o;
    }

    public String getString(int i) {
        Object o = this.getObject(i);
        return o instanceof String ? (String)o : JsSystem.toString(o);
    }

    public final void setInt(int i, int v) {
        this.setNumber(i, (double)v);
    }

    public final void setNumber(int i, double v) {
        if (i >= this.size) {
            this.setObject(i, null);
        }
        this.objects[i] = NUMBER_MARKER;
        this.numbers[i] = v;
    }

    public final void setObject(int i, Object v) {
        if (i >= this.size) {
            this.size = i + 1;
            if (i >= this.objects.length) {
                double[] newNums = new double[i * 3 / 2];
                System.arraycopy(this.numbers, 0, newNums, 0, this.numbers.length);
                this.numbers = newNums;
                Object[] newObjects = new Object[this.numbers.length];
                System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
                this.objects = newObjects;
            }
        }
        if (v instanceof Double) {
            this.numbers[i] = (Double)v;
            this.objects[i] = NUMBER_MARKER;
        } else {
            this.objects[i] = v;
        }
    }

    public void swap(int i1, int i2) {
        double f = this.numbers[i1];
        Object o = this.objects[i1];
        this.numbers[i1] = this.numbers[i2];
        this.objects[i1] = this.objects[i2];
        this.numbers[i2] = f;
        this.objects[i2] = o;
    }

    public void copy(int from, JsArray target, int to, int len) {
        if (target.size < to + len) {
            target.setObject(to + len - 1, null);
        }
        int maxIdx = Math.min(this.size, from + len);
        int l = Math.max(0, maxIdx - from);
        System.arraycopy(this.numbers, from, target.numbers, to, l);
        System.arraycopy(this.objects, from, target.objects, to, l);
        int i = to + l;
        while (i < maxIdx) {
            target.objects[i] = null;
            ++i;
        }
    }

    public void copy(int from, JsArray target, int to) {
        if (from >= this.size) {
            target.setObject(to, null);
            return;
        }
        if (to >= target.size) {
            target.setObject(to, null);
        }
        target.numbers[to] = this.numbers[from];
        target.objects[to] = this.objects[from];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.size > 0) {
            buf.append(JsSystem.toString(this.getObject(0)));
            int i = 1;
            while (i < this.size) {
                buf.append(",");
                buf.append(JsSystem.toString(this.getObject(i)));
                ++i;
            }
        }
        return buf.toString();
    }

    public boolean isNumber(int i) {
        if (i >= this.size) {
            return true;
        }
        Object o = this.objects[i];
        return o == NUMBER_MARKER || o == Boolean.TRUE || o == Boolean.FALSE || o instanceof JsDate;
    }

    public boolean isArrayIndex(int i) {
        if (i >= this.size) {
            return false;
        }
        Object o = this.objects[i];
        if (o == NUMBER_MARKER) {
            double d = this.numbers[i];
            return d >= 0.0 && d == (double)((int)d);
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.length() == 0) {
                return false;
            }
            int j = 0;
            while (j < s.length()) {
                char c = s.charAt(j);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public void vmSetOperation(JsArray stack, int keyIndex, int valueIndex) {
        if (stack.isArrayIndex(keyIndex)) {
            stack.copy(valueIndex, this, stack.getInt(keyIndex));
        } else {
            super.vmSetOperation(stack, keyIndex, valueIndex);
        }
    }

    public Enumeration keys() {
        Vector v = new Vector();
        Enumeration e = super.keys();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        int i = 0;
        while (i < this.size) {
            if (this.objects[i] != null) {
                v.addElement(new Double(i));
            }
            ++i;
        }
        return v.elements();
    }

    public void vmGetOperation(JsArray stack, int keyIndex, int valueIndex) {
        if (stack.isArrayIndex(keyIndex)) {
            this.copy(stack.getInt(keyIndex), stack, valueIndex);
        } else {
            super.vmGetOperation(stack, keyIndex, valueIndex);
        }
    }

    public boolean isNull(int i) {
        return i >= this.size || this.objects[i] == null || this.objects[i] == JsSystem.JS_NULL;
    }

    public void evalNative(int index, JsArray stack, int sp, int parCount) {
        switch (index) {
            case 42: {
                JsArray array = new JsArray();
                this.copy(0, array, 0, this.size);
                stack.copy(sp + 2, array, this.size, parCount);
                stack.setObject(sp, (Object)array);
                break;
            }
            case 405: {
                StringBuffer buf = new StringBuffer();
                String sep = stack.isNull(sp + 2) ? "," : stack.getString(sp + 2);
                int i = 0;
                while (i < this.size) {
                    if (i > 0) {
                        buf.append(sep);
                    }
                    if (!this.isNull(i)) {
                        buf.append(this.getString(i));
                    }
                    ++i;
                }
                stack.setObject(sp, (Object)buf.toString());
                break;
            }
            case 57: {
                this.setSize(stack.getInt(sp));
                break;
            }
            case 56: {
                stack.setInt(sp, this.size);
                break;
            }
            case 406: {
                if (this.size == 0) {
                    stack.setObject(sp, null);
                    break;
                }
                this.copy(this.size - 1, stack, sp);
                this.setSize(this.size - 1);
                break;
            }
            case 407: {
                stack.copy(sp + 2, this, this.size, parCount);
                stack.setNumber(sp, (double)this.size);
                break;
            }
            case 408: {
                int i = 0;
                while (i < this.size / 2) {
                    this.swap(i, this.size - 1 - i);
                    ++i;
                }
                break;
            }
            case 409: {
                if (this.size == 0) {
                    stack.setObject(sp, null);
                    break;
                }
                this.copy(0, stack, sp);
                this.copy(1, this, 0, this.size - 1);
                this.setSize(this.size - 1);
                break;
            }
            case 49: {
                int end;
                int start = stack.getInt(sp + 2);
                int n = end = stack.isNull(sp + 3) ? this.size : stack.getInt(sp + 3);
                if (start < 0) {
                    start = Math.max(this.size + start, 0);
                }
                if (end < 0) {
                    end = Math.max(this.size + start, 0);
                }
                if (start > this.size) {
                    start = this.size;
                }
                if (end > this.size) {
                    end = this.size;
                }
                if (end < start) {
                    end = start;
                }
                JsArray array = new JsArray();
                this.copy(start, array, 0, end - start);
                stack.setObject(sp, (Object)array);
                break;
            }
            case 411: {
                Object compare = stack.getObject(sp + 2);
                if (compare instanceof JsFunction) {
                    this.sort(0, this.size, (JsFunction)compare, stack.getJsObject(sp), stack, sp);
                } else {
                    this.sort(0, this.size);
                }
                stack.setObject(sp, (Object)this);
                break;
            }
            case 412: {
                JsArray array = new JsArray();
                int start = stack.getInt(sp + 2);
                int delCount = stack.getInt(sp + 3);
                if (start < 0) {
                    start = this.size - start;
                }
                int itemCount = Math.max(0, parCount - 2);
                this.copy(0, array, 0, start);
                stack.copy(sp + 4, array, start, itemCount);
                this.copy(start + delCount, array, start + itemCount, this.size - (start + delCount));
                stack.setObject(sp, (Object)array);
                break;
            }
            case 413: {
                this.copy(0, this, parCount, this.size);
                stack.copy(sp + 2, this, 0, parCount);
                stack.setInt(sp, parCount);
                break;
            }
            default: {
                super.evalNative(index, stack, sp, parCount);
            }
        }
    }

    private void sort(int left, int right) {
        if (right > left + 1) {
            int pivotIndex = left + JsSystem.random.nextInt(right - left);
            String pivotValue = this.getString(pivotIndex);
            this.swap(pivotIndex, right - 1);
            int storeIndex = left;
            int i = left;
            while (i < right - 1) {
                if (this.getString(i).compareTo(pivotValue) <= 0) {
                    this.swap(i, storeIndex++);
                }
                ++i;
            }
            this.swap(storeIndex, right - 1);
            this.sort(left, storeIndex);
            this.sort(storeIndex, right);
        }
    }

    private void sort(int left, int right, JsFunction compare, JsObject ctx, JsArray stack, int sp) {
        if (right > left + 1) {
            int pivotIndex = left + JsSystem.random.nextInt(right - left);
            this.swap(pivotIndex, right - 1);
            int storeIndex = left;
            int i = left;
            while (i < right - 1) {
                stack.setObject(sp, (Object)ctx);
                stack.setObject(sp + 1, (Object)compare);
                this.copy(i, stack, sp + 2);
                this.copy(right - 1, stack, sp + 3);
                compare.eval(stack, sp, 2);
                if (stack.getNumber(sp) <= 0.0) {
                    this.swap(i, storeIndex++);
                }
                ++i;
            }
            this.swap(storeIndex, right - 1);
            this.sort(left, storeIndex, compare, ctx, stack, sp);
            this.sort(storeIndex, right, compare, ctx, stack, sp);
        }
    }

    public void setSize(int newLen) {
        if (this.objects.length < newLen) {
            this.setObject(newLen - 1, null);
        } else {
            this.size = newLen;
        }
    }

    public void setBoolean(int i, boolean b) {
        this.setObject(i, (Object)(b ? Boolean.TRUE : Boolean.FALSE));
    }

    public int getType(int i) {
        if (i > this.size) {
            return 0;
        }
        Object o = this.objects[i];
        if (o == NUMBER_MARKER) {
            return 4;
        }
        if (o == Boolean.TRUE || o == Boolean.FALSE) {
            return 3;
        }
        if (o == null) {
            return 0;
        }
        if (o == JsSystem.JS_NULL) {
            return 1;
        }
        if (o instanceof String) {
            return 5;
        }
        if (o instanceof JsFunction) {
            return 6;
        }
        return 2;
    }
}

