/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Transform;
import net.comcraft.src.Block;
import net.comcraft.src.GuiButtonMoveControl;
import net.comcraft.src.RenderBlocks;
import net.comcraft.src.Touch;

public final class RenderBlockPreview {
    private RenderBlocks renderBlock;
    private Image[] blockPreviewImages;

    public RenderBlockPreview(RenderBlocks renderBlock) {
        this.renderBlock = renderBlock;
        this.blockPreviewImages = new Image[256];
    }

    public Image getBlockPreviewImage(int id) {
        return this.blockPreviewImages[id];
    }

    public void releaseRenderBlockPreview() {
        this.blockPreviewImages = null;
    }

    public void reloadRenderBlockPreview() {
        Camera camera = new Camera();
        camera.setPerspective(50.0f, 1.0f, 1.0f, 200.0f);
        Transform blockTrans = new Transform();
        blockTrans.postTranslate(-6.25f, -3.5f, -10.0f);
        blockTrans.postRotate(45.0f, 0.0f, 1.0f, 0.0f);
        blockTrans.postRotate(25.0f, 1.0f, 0.0f, 1.0f);
        Transform camTrans = new Transform();
        camTrans.postTranslate(0.0f, 0.0f, 18.0f);
        Background background = new Background();
        background.setColor(0xFFFFFF);
        Light light = new Light();
        light.setMode(129);
        light.setIntensity(2.0f);
        int i = 0;
        while (i < 256) {
            this.blockPreviewImages[i] = Image.createImage((int)GuiButtonMoveControl.getButtonWidth(), (int)GuiButtonMoveControl.getButtonHeight());
            if (Block.blocksList[i] != null) {
                Graphics g = this.blockPreviewImages[i].getGraphics();
                Graphics3D g3d = Graphics3D.getInstance();
                g3d.bindTarget((Object)g, true, 2);
                g3d.resetLights();
                g3d.addLight(light, camTrans);
                g3d.clear(background);
                g3d.setCamera(camera, camTrans);
                this.renderBlock.renderBlockAllFaces(Block.blocksList[i], 0, 0, 0, blockTrans);
                g3d.releaseTarget();
                if (Touch.isTouchSupported()) {
                    Image image;
                    this.blockPreviewImages[i] = image = Image.createImage((Image)this.blockPreviewImages[i], (int)0, (int)0, (int)GuiButtonMoveControl.getButtonWidth(), (int)GuiButtonMoveControl.getButtonHeight(), (int)5);
                }
            }
            ++i;
        }
    }
}

