/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import com.google.minijoe.sys.JsArray;
import com.google.minijoe.sys.JsObject;
import net.comcraft.src.Block;
import net.comcraft.src.ComcraftException;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItem;
import net.comcraft.src.World;

public final class InvItemStack
extends JsObject {
    public int stackSize;
    public int itemID;
    private int itemDamage;
    private static final int ID_GET_ITEM = 100;
    private static final int ID_GET_ITEM_DAMAGE = 101;
    private static final int ID_SET_ITEM_DAMAGE = 102;
    public static final int ID_CONSTRUCT = 103;
    private static final int ID_STACK_SIZE = 104;
    private static final int ID_ITEM_ID = 106;
    public static final JsObject ITEMSTACK_PROTOTYPE = new JsObject(JsObject.OBJECT_PROTOTYPE).addNative("getItem", 100, 0).addNative("getItemDamage", 101, 0).addNative("setItemDamage", 102, 1).addNative("stackSize", 104, -1).addNative("itemID", 106, -1);

    public InvItemStack(int itemId, int stackSize) {
        this();
        this.itemID = itemId;
        this.stackSize = stackSize;
    }

    public InvItemStack(int itemID) {
        this(itemID, 1);
    }

    public InvItemStack(Block block) {
        this(block.blockID, 1);
    }

    public InvItemStack() {
        super(ITEMSTACK_PROTOTYPE);
    }

    public InvItem getItem() {
        if (this.itemID == 0 || this.stackSize == 0) {
            return null;
        }
        InvItem item = InvItem.itemsList[this.itemID];
        if (item == null) {
            throw new ComcraftException("Unknown item id " + this.itemID, null);
        }
        return item;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public void setItemDamage(int value) {
        this.itemDamage = value;
    }

    public boolean useItem(EntityPlayer entityPlayer, World world, int x, int y, int z, int side) {
        boolean flag = this.getItem().onItemUse(this, entityPlayer, world, x, y, z, side);
        return flag;
    }

    public boolean equals(Object object) {
        if (object instanceof InvItemStack) {
            InvItemStack itemStack = (InvItemStack)object;
            return itemStack.itemID == this.itemID;
        }
        return super.equals(object);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.itemID;
        return hash;
    }

    public void evalNative(int id, JsArray stack, int sp, int parCount) {
        switch (id) {
            case 103: {
                this.itemID = stack.getInt(sp + 2);
                if (parCount > 1) {
                    this.stackSize = stack.getInt(sp + 3);
                    break;
                }
                this.stackSize = 1;
                break;
            }
            case 100: {
                stack.setObject(sp, (Object)this.getItem());
                break;
            }
            case 101: {
                stack.setInt(sp, this.getItemDamage());
                break;
            }
            case 102: {
                this.setItemDamage(stack.getInt(sp + 2));
                break;
            }
            case 104: {
                stack.setInt(sp, this.stackSize);
                break;
            }
            case 105: {
                this.stackSize = stack.getInt(sp);
                break;
            }
            case 106: {
                stack.setInt(sp, this.itemID);
                break;
            }
            case 107: {
                this.itemID = stack.getInt(sp);
                break;
            }
            default: {
                super.evalNative(id, stack, sp, parCount);
            }
        }
    }
}

