/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import net.comcraft.src.Block;
import net.comcraft.src.EntityPlayer;
import net.comcraft.src.InvItem;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.World;

public class InvItemBlock
extends InvItem {
    protected int blockID;

    public InvItemBlock(int id) {
        super(id);
        this.blockID = id + 256;
    }

    public InvItemBlock(int id, int index) {
        super(id, index);
        this.blockID = id + 256;
    }

    public String getItemUsingSound() {
        return Block.blocksList[this.blockID].getBlockPlacingSound();
    }

    public int getIconIndex() {
        return this.iconIndex == -1 ? this.blockID + 512 : this.iconIndex;
    }

    public boolean onItemUse(InvItemStack itemStack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side) {
        if (side == 0) {
            ++z;
        } else if (side == 1) {
            --z;
        } else if (side == 2) {
            ++x;
        } else if (side == 3) {
            --x;
        } else if (side == 4) {
            ++y;
        } else if (side == 5) {
            --y;
        }
        if (itemStack.stackSize == 0) {
            return false;
        }
        if (world.canBlockBePlacedAt(this.blockID, x, y, z, side)) {
            if (world.setBlockAndMetadataN(x, y, z, this.blockID, 0)) {
                if (world.getBlockID(x, y, z) == this.blockID) {
                    Block.blocksList[this.blockID].onBlockPlaced(world, x, y, z, side);
                    Block.blocksList[this.blockID].onBlockPlacedBy(world, x, y, z, entityPlayer);
                }
                --itemStack.stackSize;
            }
            return true;
        }
        return false;
    }

    public String getItemName() {
        return Block.blocksList[this.blockID].getBlockName();
    }
}

