/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import net.comcraft.src.GuiButton;
import net.comcraft.src.GuiEditServer;
import net.comcraft.src.GuiScreen;
import net.comcraft.src.GuiScreenSlotHost;
import net.comcraft.src.GuiSlotSelectServer;
import net.comcraft.src.GuiTextBox;
import net.comcraft.src.GuiTextBoxHost;
import net.comcraft.src.GuiYesNo;
import net.comcraft.src.GuiYesNoHost;

public class GuiSelectServer
extends GuiScreenSlotHost
implements GuiTextBoxHost,
GuiYesNoHost {
    private String[] selectedServer;

    public GuiSelectServer(GuiScreen parentScreen) {
        super(parentScreen, "SelectServer");
        this.guiSlot = new GuiSlotSelectServer(this);
    }

    protected void customDrawScreen() {
        this.guiSlot.drawScreen();
        this.drawTitle(this.cc.langBundle.getText("GuiSelectServer.title"));
    }

    private void selectServer(String[] serverinfo) {
        String ip = serverinfo[1];
        this.cc.serverLoader.newGame(ip);
    }

    protected void handleGuiAction(GuiButton guiButton) {
        if (!guiButton.enabled) {
            return;
        }
        if (guiButton.getId() == 0) {
            this.selectServer(this.selectedServer);
        } else if (guiButton.getId() == 1) {
            this.cc.displayGuiScreen(new GuiEditServer(this, null, null, null));
        } else if (guiButton.getId() == 2) {
            this.cc.displayGuiScreen(new GuiYesNo(this, this.cc.langBundle.getText("GuiSelectWorld.deleteWorld.confirmationText")));
        } else if (guiButton.getId() == 3) {
            this.backToParentScreen();
        } else if (guiButton.getId() == 4) {
            this.cc.displayGuiScreen(new GuiEditServer(this, this.selectedServer[0], this.selectedServer[1], this.selectedServer));
        } else if (guiButton.getId() == 5) {
            this.cc.displayGuiScreen(new GuiTextBox(this, this.cc.settings.username, 0, 16));
        }
    }

    protected void initGuiSlotCustom() {
        this.cc.serverLoader.updateServerList();
        this.addButton(this.cc.langBundle.getText("GuiSelectServer.buttonConnect"), false, 2, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectServer.buttonAdd"), true, 1, 0);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonDelete"), false, 2, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectWorld.buttonClose"), this.parentScreen != null, 0, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectServer.buttonEdit"), false, 1, 1);
        this.addButton(this.cc.langBundle.getText("GuiSelectServer.buttonChangeName"), true, 0, 0);
        this.elementClicked(0);
    }

    public void onScreenClosed() {
    }

    public void onScreenDisplay() {
        this.selectedServer = this.guiSlot.selectedElement > -1 ? (String[])this.getElementsList().elementAt(this.guiSlot.selectedElement) : null;
    }

    public void elementClicked(int id) {
        if (id >= this.getElementsList().size() || id < 0) {
            this.getButton(0).setEnabled(false);
            this.getButton(2).setEnabled(false);
            this.getButton(4).setEnabled(false);
            this.selectedServer = null;
            return;
        }
        this.selectedServer = (String[])this.getElementsList().elementAt(id);
        this.getButton(0).setEnabled(true);
        this.getButton(2).setEnabled(true);
        this.getButton(4).setEnabled(true);
    }

    public Vector getElementsList() {
        return this.cc.serverLoader.getServerList();
    }

    public void guiYesNoAction(boolean value) {
        if (value) {
            this.cc.serverLoader.deleteServer(this.selectedServer);
            this.cc.serverLoader.updateServerList();
            this.guiSlot.resetSlot();
            if (!this.getButton((int)2).enabled) {
                this.selectedButton = this.getNextAvailableButton();
            }
        }
    }

    public void guiTextBoxAction(String username) {
        if (username == null || username.equals("")) {
            return;
        }
        this.cc.settings.username = username;
    }
}

