/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Vector;
import net.comcraft.client.Comcraft;
import net.comcraft.src.Block;
import net.comcraft.src.GuiInventory;
import net.comcraft.src.InvItem;
import net.comcraft.src.InvItemStack;
import net.comcraft.src.Keyboard;
import net.comcraft.src.Touch;

public class GuiContainerInventory {
    private Comcraft cc;
    private GuiInventory guiInventory;
    private int rows;
    private int cols;
    private int width;
    private int height;
    private int xPos;
    private int yPos;
    private int amountScrolled;
    private int selectedIndex;
    private Vector itemStackList;
    private Vector lockedItems;

    public GuiContainerInventory(Comcraft cc, GuiInventory guiInventory, int xPos, int yPos) {
        this.cc = cc;
        this.guiInventory = guiInventory;
        this.amountScrolled = 0;
        this.xPos = xPos;
        this.yPos = yPos;
        this.itemStackList = new Vector(256);
        this.lockedItems = new Vector(256);
        this.selectedIndex = Touch.isTouchSupported() ? -1 : 0;
        this.initItemStackList();
        this.initGuiContainer();
    }

    public InvItemStack getCurrentItem() {
        return (InvItemStack)this.itemStackList.elementAt(this.selectedIndex);
    }

    private void initGuiContainer() {
        if (Touch.isTouchSupported()) {
            if (Comcraft.getScreenWidth() == 240) {
                this.width = 150;
            } else if (Comcraft.getScreenWidth() == 320) {
                this.width = 250;
            } else if (Comcraft.getScreenWidth() == 360) {
                this.width = 250;
            } else if (Comcraft.getScreenWidth() == 176) {
                this.width = 150;
            } else if (Comcraft.getScreenWidth() == 480) {
                this.width = 400;
            }
            if (Comcraft.getScreenHeight() == 320) {
                this.height = 300;
            } else if (Comcraft.getScreenHeight() == 220) {
                this.height = 150;
            } else if (Comcraft.getScreenHeight() == 240) {
                this.height = 200;
            } else if (Comcraft.getScreenHeight() == 400) {
                this.height = 350;
            } else if (Comcraft.getScreenHeight() == 640) {
                this.height = 600;
            } else if (Comcraft.getScreenHeight() == 480) {
                this.height = 450;
            } else if (Comcraft.getScreenHeight() == 800) {
                this.height = 600;
            }
        } else {
            if (Comcraft.getScreenWidth() == 240) {
                this.width = 200;
            } else if (Comcraft.getScreenWidth() == 176) {
                this.width = 150;
            } else if (Comcraft.getScreenWidth() == 360) {
                this.width = 350;
            } else if (Comcraft.getScreenWidth() == 320) {
                this.width = 300;
            } else if (Comcraft.getScreenWidth() == 480) {
                this.width = 450;
            }
            if (Comcraft.getScreenHeight() == 320) {
                this.height = 250;
            } else if (Comcraft.getScreenHeight() == 220) {
                this.height = 150;
            } else if (Comcraft.getScreenHeight() == 240) {
                this.height = 150;
            } else if (Comcraft.getScreenHeight() == 400) {
                this.height = 300;
            } else if (Comcraft.getScreenHeight() == 640) {
                this.height = 550;
            } else if (Comcraft.getScreenHeight() == 480) {
                this.height = 400;
            } else if (Comcraft.getScreenHeight() == 800) {
                this.height = 550;
            }
        }
        this.cols = Touch.isTouchSupported() ? this.height / 50 : this.width / 50;
        this.rows = this.itemStackList.size() / this.cols + 1;
        if (!Touch.isTouchSupported()) {
            this.checkSelectedElement();
        }
    }

    private void addItem(InvItem item) {
        this.itemStackList.addElement(new InvItemStack(item.shiftedIndex, 1));
    }

    private void addBlock(Block block) {
        this.itemStackList.addElement(new InvItemStack(block.blockID, 1));
    }

    private void initItemStackList() {
        this.addBlock(Block.getBlock("stone"));
        this.addBlock(Block.getBlock("grass"));
        this.addItem(InvItem.hammer);
        this.addBlock(Block.getBlock("dirt"));
        this.addBlock(Block.getBlock("sand"));
        this.addBlock(Block.getBlock("cobblestone"));
        this.addBlock(Block.getBlock("leaves"));
        this.addBlock(Block.getBlock("glass"));
        this.addBlock(Block.getBlock("wood"));
        this.addBlock(Block.getBlock("wood1"));
        this.addBlock(Block.getBlock("wood2"));
        this.addBlock(Block.getBlock("planks"));
        this.addBlock(Block.getBlock("planks1"));
        this.addBlock(Block.getBlock("planks2"));
        this.addBlock(Block.getBlock("planks3"));
        this.addItem(InvItem.detonator);
        this.addItem(InvItem.seeds);
        this.addBlock(Block.getBlock("tnt"));
        this.addBlock(Block.getBlock("tntWeak"));
        this.addBlock(Block.getBlock("tntStrong"));
        this.addBlock(Block.getBlock("torch"));
        this.addBlock(Block.getBlock("woodenDoor"));
        this.addBlock(Block.getBlock("ironDoor"));
        this.addBlock(Block.getBlock("bedrock"));
        this.addBlock(Block.getBlock("lapisLazuli"));
        this.addBlock(Block.getBlock("sandStone"));
        this.addBlock(Block.getBlock("woolWhite"));
        this.addBlock(Block.getBlock("woolRed"));
        this.addBlock(Block.getBlock("woolOrange"));
        this.addBlock(Block.getBlock("woolYellow"));
        this.addBlock(Block.getBlock("woolLime"));
        this.addBlock(Block.getBlock("woolGreen"));
        this.addBlock(Block.getBlock("woolLightBlue"));
        this.addBlock(Block.getBlock("woolCyan"));
        this.addBlock(Block.getBlock("woolBlue"));
        this.addBlock(Block.getBlock("woolMagenta"));
        this.addBlock(Block.getBlock("woolPink"));
        this.addBlock(Block.getBlock("woolPurple"));
        this.addBlock(Block.getBlock("woolBrown"));
        this.addBlock(Block.getBlock("woolLightGray"));
        this.addBlock(Block.getBlock("woolGray"));
        this.addBlock(Block.getBlock("woolBlack"));
        this.addBlock(Block.getBlock("cactus"));
        this.addBlock(Block.getBlock("redFlower"));
        this.addBlock(Block.getBlock("yellowFlower"));
        this.addBlock(Block.getBlock("treePlant"));
        this.addBlock(Block.getBlock("mushroom"));
        this.addBlock(Block.getBlock("toadstool"));
        this.addBlock(Block.getBlock("wheat"));
        this.addBlock(Block.getBlock("fencePlank"));
        this.addBlock(Block.getBlock("fencePlank2"));
        this.addBlock(Block.getBlock("fencePlank3"));
        this.addBlock(Block.getBlock("fencePlank4"));
        this.addBlock(Block.getBlock("fenceStone"));
        this.addBlock(Block.getBlock("fenceBrick"));
        this.addBlock(Block.getBlock("fenceNetherbrick"));
        this.addBlock(Block.getBlock("iron"));
        this.addBlock(Block.getBlock("gold"));
        this.addBlock(Block.getBlock("diamond"));
        this.addBlock(Block.getBlock("doubleStoneSlab"));
        this.addBlock(Block.getBlock("stoneSlab"));
        this.addBlock(Block.getBlock("plankSlab"));
        this.addBlock(Block.getBlock("plankSlab1"));
        this.addBlock(Block.getBlock("plankSlab2"));
        this.addBlock(Block.getBlock("plankSlab3"));
        this.addBlock(Block.getBlock("cobblestoneSlab"));
        this.addBlock(Block.getBlock("brickSlab"));
        this.addBlock(Block.getBlock("netherBrickSlab"));
        this.addBlock(Block.getBlock("whiteWoolSlab"));
        this.addBlock(Block.getBlock("redWoolSlab"));
        this.addBlock(Block.getBlock("orangeWoolSlab"));
        this.addBlock(Block.getBlock("yellowWoolSlab"));
        this.addBlock(Block.getBlock("lightGreenWoolSlab"));
        this.addBlock(Block.getBlock("greenWoolSlab"));
        this.addBlock(Block.getBlock("blueWoolSlab"));
        this.addBlock(Block.getBlock("pinkWoolSlab"));
        this.addBlock(Block.getBlock("blackWoolSlab"));
        this.addBlock(Block.getBlock("craftingTable"));
        this.addBlock(Block.getBlock("bed"));
        this.addBlock(Block.getBlock("furnace"));
        this.addBlock(Block.getBlock("chest"));
        this.addBlock(Block.getBlock("water"));
        this.addBlock(Block.getBlock("lava"));
        this.addBlock(Block.getBlock("stoneTitle"));
        this.addBlock(Block.getBlock("plankTitle"));
        this.addBlock(Block.getBlock("plankTitle1"));
        this.addBlock(Block.getBlock("plankTitle2"));
        this.addBlock(Block.getBlock("plankTitle3"));
        this.addBlock(Block.getBlock("cobblestoneTitle"));
        this.addBlock(Block.getBlock("brickTitle"));
        this.addBlock(Block.getBlock("netherBrickTitle"));
        this.addBlock(Block.getBlock("brick"));
        this.addBlock(Block.getBlock("bookshelve"));
        this.addBlock(Block.getBlock("mossStone"));
        this.addBlock(Block.getBlock("obsidian"));
        this.addBlock(Block.getBlock("ice"));
        this.addBlock(Block.getBlock("snowBlock"));
        this.addBlock(Block.getBlock("snow"));
        this.addBlock(Block.getBlock("pumpkin"));
        this.addBlock(Block.getBlock("netherrack"));
        this.addBlock(Block.getBlock("soulSand"));
        this.addBlock(Block.getBlock("stoneBrick"));
        this.addBlock(Block.getBlock("netherBrick"));
        this.addBlock(Block.getBlock("plankStairs"));
        this.addBlock(Block.getBlock("plankStairs1"));
        this.addBlock(Block.getBlock("plankStairs2"));
        this.addBlock(Block.getBlock("plankStairs3"));
        this.addBlock(Block.getBlock("brickStairs"));
        this.addBlock(Block.getBlock("netherBrickStairs"));
        this.addBlock(Block.getBlock("stoneStairs"));
        this.addBlock(Block.getBlock("cobblestoneStairs"));
        this.addBlock(Block.getBlock("whiteWoolStairs"));
        this.addBlock(Block.getBlock("redWoolStairs"));
        this.addBlock(Block.getBlock("orangeWoolStairs"));
        this.addBlock(Block.getBlock("yellowWoolStairs"));
        this.addBlock(Block.getBlock("lightGreenWoolStairs"));
        this.addBlock(Block.getBlock("greenWoolStairs"));
        this.addBlock(Block.getBlock("blueWoolStairs"));
        this.addBlock(Block.getBlock("pinkWoolStairs"));
        this.addBlock(Block.getBlock("blackWoolStairs"));
        this.addBlock(Block.getBlock("emoticon"));
        this.addBlock(Block.getBlock("alphabet1"));
        this.addBlock(Block.getBlock("alphabet2"));
        this.addBlock(Block.getBlock("numbers"));
        this.addBlock(Block.getBlock("animalPig"));
        this.addBlock(Block.getBlock("animalSheep"));
        this.addBlock(Block.getBlock("animalCow"));
        this.addBlock(Block.getBlock("animalChicken"));
        int id = 0;
        while (id < Block.blocksList.length) {
            if (id != Block.getBlock((String)"Player").blockID) {
                InvItemStack itemStack = new InvItemStack(id, 1);
                if (Block.blocksList[id] != null && !this.itemStackList.contains(itemStack)) {
                    this.itemStackList.addElement(itemStack);
                }
            }
            ++id;
        }
    }

    public void drawContainer() {
        this.cc.g.setClip(this.xPos, this.yPos, this.width, this.height);
        int rowsI = 0;
        while (rowsI < this.rows) {
            int colsI = 0;
            while (colsI < this.cols) {
                int y;
                int x;
                int id = colsI + rowsI * this.cols;
                InvItemStack itemStack = null;
                if (id < this.itemStackList.size()) {
                    itemStack = (InvItemStack)this.itemStackList.elementAt(id);
                }
                if (Touch.isTouchSupported()) {
                    x = this.xPos + rowsI * 50;
                    y = this.yPos + colsI * 50;
                } else {
                    x = this.xPos + colsI * 50;
                    y = this.yPos + rowsI * 50;
                }
                this.drawSlot(itemStack, x, y, id);
                ++colsI;
            }
            ++rowsI;
        }
        this.cc.g.setClip(0, 0, Comcraft.screenWidth, Comcraft.screenHeight);
    }

    private void drawSlot(InvItemStack itemStack, int x, int y, int id) {
        if (Touch.isTouchSupported()) {
            x += this.amountScrolled;
        } else {
            y += this.amountScrolled;
        }
        if (itemStack != null) {
            this.cc.g.drawImage(this.cc.textureProvider.getItemTexture(itemStack.getItem().getIconIndex()), x, y, 20);
            if (this.lockedItems.contains(new Integer(itemStack.itemID))) {
                this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/locked_item.png"), x, y, 20);
            }
        } else {
            this.cc.g.setColor(0xFFFFFF);
            this.cc.g.fillRect(x, y, 50, 50);
        }
        this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/inventory_slot.png"), x, y, 20);
        if (this.selectedIndex == id) {
            this.cc.g.drawImage(this.cc.textureProvider.getImage("gui/inventory_slot_selection.png"), x, y, 20);
        }
    }

    public boolean isPointAtContainer(int x, int y) {
        return x >= this.xPos && x <= this.xPos + this.width && y >= this.yPos && y <= this.yPos + this.height;
    }

    private void elementClicked(int x, int y) {
        x -= this.xPos;
        int yEl = (y -= this.yPos) / 50;
        int xEl = (x -= this.amountScrolled) / 50;
        int id = yEl + xEl * this.cols;
        if (id < this.itemStackList.size()) {
            InvItemStack itemStack = (InvItemStack)this.itemStackList.elementAt(id);
            if (!this.lockedItems.contains(new Integer(itemStack.itemID))) {
                this.guiInventory.clickedItemStack(itemStack);
            }
        }
    }

    private void checkSelectedElement() {
        int sRow = this.selectedIndex / this.cols - 1;
        this.amountScrolled = sRow * -50 + 25;
    }

    private void handleKeyboardInput() {
        if (Keyboard.wasButtonDown(-3) || Keyboard.wasButtonDown(97)) {
            this.selectedIndex = this.selectedIndex > 0 ? --this.selectedIndex : this.itemStackList.size() - 1;
            this.checkSelectedElement();
        } else if (Keyboard.wasButtonDown(-4) || Keyboard.wasButtonDown(100)) {
            this.selectedIndex = this.selectedIndex < this.itemStackList.size() - 1 ? ++this.selectedIndex : 0;
            this.checkSelectedElement();
        } else if (Keyboard.wasButtonDown(-1) || Keyboard.wasButtonDown(119)) {
            this.selectedIndex -= this.cols;
            if (this.selectedIndex < 0) {
                this.selectedIndex = this.itemStackList.size() - 1;
            }
            this.checkSelectedElement();
        } else if (Keyboard.wasButtonDown(-2) || Keyboard.wasButtonDown(115)) {
            this.selectedIndex += this.cols;
            if (this.selectedIndex >= this.itemStackList.size()) {
                this.selectedIndex = 0;
            }
            this.checkSelectedElement();
        } else if (Keyboard.wasButtonDown(-5) || Keyboard.wasButtonDown(102)) {
            InvItemStack itemStack = (InvItemStack)this.itemStackList.elementAt(this.selectedIndex);
            if (!this.lockedItems.contains(new Integer(itemStack.itemID))) {
                this.guiInventory.clickedItemStack(itemStack);
            }
        }
    }

    private void scrollContainer(int difference) {
        this.amountScrolled -= difference;
        if (this.amountScrolled > 50) {
            this.amountScrolled = 50;
        }
        if (this.amountScrolled < (this.rows - 1) * -50 + 50) {
            this.amountScrolled = (this.rows - 1) * -50 + 50;
        }
    }

    private void handleTouchInput() {
        if (this.isPointAtContainer(Touch.getX(), Touch.getY())) {
            if (!Touch.isPressed() && Touch.wasPressed() && !Touch.wasDragged()) {
                this.elementClicked(Touch.getX(), Touch.getY());
            } else if (Touch.isDragged()) {
                this.scrollContainer(Touch.getTouchXDifference());
            }
            Touch.setInputHandled();
        }
    }

    public void handleInput() {
        this.handleKeyboardInput();
        this.handleTouchInput();
    }
}

