/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.src.ComcraftException;

public final class FileSystemHelper {
    private FileSystemHelper() {
    }

    public static Vector getElementsList(FileConnection fileConnection) {
        try {
            Enumeration enumeration = fileConnection.list();
            Vector<String> elements = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                String elementPath = String.valueOf(fileConnection.getURL()) + (String)enumeration.nextElement();
                elements.addElement(elementPath);
            }
            return elements;
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public static Vector getElementsList(Enumeration enumeration) {
        Vector<String> elements = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String elementPath = "file:///" + (String)enumeration.nextElement();
            elements.addElement(elementPath);
        }
        return elements;
    }

    public static String getLastPathName(String path) {
        if (FileSystemHelper.isDirectory(path)) {
            path = path.substring(0, path.length() - 1);
        }
        String pathName = "";
        int i = path.length();
        while (!pathName.startsWith("/") && i >= 0) {
            pathName = path.substring(i);
            --i;
        }
        pathName = pathName.substring(1);
        return pathName;
    }

    public static String getPathWithoutPrefix(String path) {
        return path.substring(8);
    }

    public static boolean isDirectory(String path) {
        return path.endsWith("/");
    }
}

