/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.comcraft.client.Comcraft;
import net.comcraft.src.ComcraftException;

public final class ComcraftFileSystem {
    private String comcraftPath;

    public ComcraftFileSystem(Comcraft cc, String path) {
        this.comcraftPath = path;
    }

    public void initComcraftFileSystem() {
        if (!this.isAvailable()) {
            return;
        }
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/");
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/" + "mods/");
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/" + "saves/");
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/" + "texturepacks/");
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/" + "music/");
        this.initFolder(String.valueOf(this.comcraftPath) + "comcraft/" + "screenshots/");
    }

    private void initFolder(String path) {
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)path, (int)3);
            if (!fileConnection.exists()) {
                fileConnection.mkdir();
            }
            fileConnection.close();
        }
        catch (IOException ex) {
            throw new ComcraftException(ex);
        }
    }

    public String getPathToFolder(String folder) {
        return String.valueOf(this.comcraftPath) + "comcraft/" + folder;
    }

    public String getComcraftPath() {
        return this.isAvailable() ? this.comcraftPath : "";
    }

    public boolean isAvailable() {
        return this.comcraftPath != null && !this.comcraftPath.equals("");
    }
}

