/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import java.util.Calendar;
import net.comcraft.src.Block;
import net.comcraft.src.ChunkGenerator;
import net.comcraft.src.ChunkStorage;

public class ChunkGeneratorFlat
extends ChunkGenerator {
    private int level;

    public ChunkGeneratorFlat(long seed, int level) {
        super(seed);
        this.level = level;
    }

    public ChunkStorage[] generateChunk(int chunkX, int chunkZ) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 11 && calendar.get(5) != 24 && calendar.get(5) != 25) {
            calendar.get(5);
        }
        boolean isHalloweenToday = calendar.get(2) == 9 && calendar.get(5) == 31;
        ChunkStorage[] blockStorage = new ChunkStorage[8];
        int i = 0;
        while (i < 8) {
            blockStorage[i] = new ChunkStorage();
            ++i;
        }
        int y = 0;
        while (y < 32) {
            ChunkStorage blockStorageTemp = blockStorage[y >> 2];
            int z = 0;
            while (z < 4) {
                int x = 0;
                while (x < 4) {
                    int id = 0;
                    if (y == 0) {
                        id = Block.getBlock((String)"bedrock").blockID;
                    } else if (y >= 1 && y <= 3) {
                        id = Block.getBlock((String)"stone").blockID;
                    } else if (y >= 4 && y <= 10) {
                        int i2 = this.random.nextInt(y - 3);
                        id = i2 == 0 ? Block.getBlock((String)"stone").blockID : Block.getBlock((String)"dirt").blockID;
                    }
                    if (y < this.level - 1 && y >= 11) {
                        id = Block.getBlock((String)"dirt").blockID;
                    }
                    if (y == this.level - 1) {
                        id = Block.getBlock((String)"dirt").blockID;
                    }
                    if (y == this.level) {
                        id = Block.getBlock((String)"grass").blockID;
                    }
                    if (y > this.level) {
                        id = 0;
                    }
                    if (y == this.level + 1 && isHalloweenToday && this.random.nextInt(30) == 0) {
                        id = Block.getBlock((String)"pumpkin").blockID;
                    }
                    id = this.runModGens(id, -1, this.level, x, y, z, chunkX, chunkZ);
                    blockStorageTemp.setBlockID(x, y & 3, z, id);
                    ++x;
                }
                ++z;
            }
            ++y;
        }
        return blockStorage;
    }
}

