/*
 * Decompiled with CFR 0.152.
 */
package net.comcraft.src;

import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import net.comcraft.src.AxisAlignedBB;
import net.comcraft.src.Block;
import net.comcraft.src.ModelFence;
import net.comcraft.src.World;

public class BlockFence
extends Block {
    public BlockFence(int id, int index) {
        super(id, index);
    }

    public boolean doesBlockDestroyGrass() {
        return false;
    }

    public boolean canBePieced() {
        return false;
    }

    public boolean canBePiecedVertically() {
        return false;
    }

    public boolean shouldSideBeRendered(World world, int x, int y, int z, int side) {
        if (world == null) {
            return side < 6;
        }
        if (side > 5) {
            return world.getBlockID(x, y, z - 1) == this.blockID || world.getBlockID(x, y, z + 1) == this.blockID;
        }
        if (world.getBlockID(x - 1, y, z) == this.blockID || world.getBlockID(x + 1, y, z) == this.blockID) {
            return true;
        }
        return world.getBlockID(x, y, z - 1) != this.blockID && world.getBlockID(x, y, z + 1) != this.blockID;
    }

    public int getRenderType() {
        return 8;
    }

    public VertexBuffer[] getBlockVertexBufferSided(World world, int x, int y, int z) {
        if (world == null) {
            return ModelFence.vertexBufferFull;
        }
        if (world.getBlockID(x, y, z - 1) == this.blockID || world.getBlockID(x, y, z + 1) == this.blockID || world.getBlockID(x - 1, y, z) == this.blockID || world.getBlockID(x + 1, y, z) == this.blockID) {
            return ModelFence.vertexBufferFull;
        }
        return ModelFence.vertexBufferSmall;
    }

    public Transform getBlockTransform(World world, int x, int y, int z, Transform transform, int side) {
        if (world == null) {
            return transform;
        }
        Transform blockTransform = new Transform();
        blockTransform.set(transform);
        if (side > 5 && (world.getBlockID(x, y, z - 1) == this.blockID || world.getBlockID(x, y, z + 1) == this.blockID)) {
            blockTransform.postRotate(90.0f, 0.0f, 1.0f, 0.0f);
            blockTransform.postTranslate(-10.0f, 0.0f, 0.0f);
        }
        return blockTransform;
    }

    public IndexBuffer getBlockIndexBuffer() {
        return ModelFence.indexBuffer;
    }

    public boolean isNormal() {
        return false;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        if (world.getBlockID(x, y, z - 1) == this.blockID || world.getBlockID(x, y, z + 1) == this.blockID) {
            if (world.getBlockID(x - 1, y, z) == this.blockID || world.getBlockID(x + 1, y, z) == this.blockID) {
                return AxisAlignedBB.getBoundingBox(x, y, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
            }
            return AxisAlignedBB.getBoundingBox((float)x + 0.3f, y, z, (float)x + 0.7f, (float)y + 1.0f, (float)z + 1.0f);
        }
        if (world.getBlockID(x - 1, y, z) == this.blockID || world.getBlockID(x + 1, y, z) == this.blockID) {
            return AxisAlignedBB.getBoundingBox(x, y, (float)z + 0.3f, (float)x + 1.0f, (float)y + 1.0f, (float)z + 0.7f);
        }
        return AxisAlignedBB.getBoundingBox((float)x + 0.3f, y, (float)z + 0.3f, (float)x + 0.7f, (float)y + 1.0f, (float)z + 0.7f);
    }
}

